! PGQVP -- Inquire viewport size and position

subroutine PGQVP( units, x1, x2, y1, y2 )

   integer,          intent(in)  :: units
   double precision, intent(out) :: x1, x2, y1, y2
   !------ API end ------

   ! Inquiry routine to determine the current viewport setting.
   ! The values returned may be normalized device coordinates, inches, mm,
   ! or pixels, depending on the value of the input parameter UNITS.
   !
   ! Arguments:
   !  UNITS  (input)  : used to specify the units of the output parameters:
   !                    UNITS = 0 : normalized device coordinates
   !                    UNITS = 1 : inches
   !                    UNITS = 2 : millimeters
   !                    UNITS = 3 : pixels
   !                    Other values give an error message, and are
   !                    treated as 0.
   !  X1     (output) : the x-coordinate of the bottom left corner of the
   !                    viewport.
   !  X2     (output) : the x-coordinate of the top right corner of the
   !                    viewport.
   !  Y1     (output) : the y-coordinate of the bottom left corner of the
   !                    viewport.
   !  Y2     (output) : the y-coordinate of the top right corner of the
   !                    viewport.
   !--
   ! 26-Sep-1985 - New routine (TJP).
   ! 29-Feb-2020 - Use now double precision instead of single precision [EC].
   ! 16-Apr-2020 - Modified to take into account suppression of panels [EC].
   !-----------------------------------------------------------------------

   double precision :: sx, sy

   !------ end of declarations -- execution starts hereafter  ------

   if( units == 0 ) then
      sx = grxmxa(grcide)
      sy = grymxa(grcide)
   else if( units == 1 ) then
      sx = pgxpin(pgid)
      sy = pgypin(pgid)
   else if( units == 2 ) then
      sx = pgxpin(pgid)/25.4d0
      sy = pgypin(pgid)/25.4d0
   else if( units == 3 ) then
      sx = 1.0d0
      sy = 1.0d0
   else
      call grwarn( "PGQVP: Illegal value for parameter UNITS" )
      sx = grxmxa(grcide)
      sy = grymxa(grcide)
   end if

   x1 = pgxvp(pgid)/sx
   x2 = (pgxvp(pgid)+pgxlen(pgid))/sx
   y1 = pgyvp(pgid)/sy
   y2 = (pgyvp(pgid)+pgylen(pgid))/sy

end subroutine
