! PGQINF -- Inquire MFPLOT general information

subroutine PGQINF( item, value, length )

   character(len=*), intent(in)  :: item
   character(len=*), intent(out) :: value
   integer,          intent(out) :: length

   ! This routine can be used to obtain miscellaneous information about
   ! the MFPLOT environment. Input is a character string defining the
   ! information required, and output is a character string containing the
   ! requested information.
   !
   ! The following item codes are accepted (note that the strings must
   ! match exactly, except for case, but only the first 8 characters are
   ! significant). For items marked *, MFPLOT must be in the OPEN state
   ! for the inquiry to succeed. If the inquiry is unsuccessful, either
   ! because the item code is not recognized or because the information
   ! is not available, a question mark ('?') is returned.
   !
   !   'TYPE'      * - device-type of the current MFPLOT device.
   !   'CURSOR'    * - does the current device have a graphics cursor?
   !                   ('YES' or 'NO').
   !
   ! Arguments:
   !  ITEM  (input)  : character string defining the information to
   !                   be returned; see above for a list of possible
   !                   values.
   !  VALUE (output) : returns a character-string containing the
   !                   requested information, truncated to the length
   !                   of the supplied string or padded on the right with
   !                   spaces if necessary.
   !  LENGTH (output): the number of characters returned in VALUE
   !                   (excluding trailing blanks).
   !--
   ! 18-Feb-1988 - [TJP].
   ! 30-Aug-1988 - Remove pseudo logical use of IER.
   ! 12-Mar-1992 - Change comments for clarity.
   ! 17-Apr-1995 - Clean up some zero-length string problems [TJP].
   !  7-Jul-1995 - Get cursor information directly from driver [TJP].
   ! 24-Feb-1997 - Add SCROLL request.
   ! 12-Apr-2020 - Simplify extremely the routine. In Muesli, only two keys
   !               are requested: 'CURSOR' and 'TYPE' [EC].
   !-----------------------------------------------------------------------

   integer :: ier
   logical :: inter
   character(len=8) :: test
   character(len=64) :: dev1

   !------ end of declarations -- execution starts hereafter  ------

   ! Initialize MFPLOT if necessary.
   call pginit

   call grtoup( test, item )

   if( pgid < 1 .or. pgmaxd < pgid ) then
      ier = 0
   else if( pgdevs(pgid) == 0 ) then
      ier = 0
   else if( test == 'TYPE' ) then
      call grqtyp(value,inter)
      length = len_trim(value)
      ier = 0
      if( length > 0) ier = 1
   else if( test == 'CURSOR' ) then
      call grqcap(dev1)
      if( dev1(2:2) == 'N' ) then
         value = 'NO'
         length = 2
      else
         value = 'YES'
         length = 3
      end if
      ier = 1
   else
      ier = 0
   end if

   if( ier /= 1 ) then
      value = '?'
      length = 1
   else if( length < 1 ) then
      length = 1
      value = ' '
   end if

end subroutine
