! PGQHS -- Inquire hatching style

subroutine PGQHS( angle, sepn, phase )

   double precision :: angle, sepn, phase

   ! Query the style to be used hatching (fill area with fill-style 3).
   !
   ! Arguments:
   !  ANGLE  (output) : the angle the hatch lines make with the
   !                    horizontal, in degrees, increasing
   !                    counterclockwise (this is an angle on the
   !                    view surface, not in world-coordinate space).
   !  SEPN   (output) : the spacing of the hatch lines. The unit spacing
   !                    is 1 percent of the smaller of the height or
   !                    width of the view surface.
   !  PHASE  (output) : a real number between 0 and 1; the hatch lines
   !                    are displaced by this fraction of SEPN from a
   !                    fixed reference.  Adjacent regions hatched with the
   !                    same PHASE have contiguous hatch lines.
   !--
   ! 26-Feb-1995 - New routine [TJP].
   ! 19-Jun-1995 - Correct synopsis [TJP].
   ! 29-Feb-2020 - Use now double precision instead of single precision [EC].
   !-----------------------------------------------------------------------

   angle = pghsa(pgid)
   sepn  = pghss(pgid)
   phase = pghsp(pgid)

end subroutine
