! PGPT -- Draw several graph markers

subroutine PGPT( n, xpts, ypts, symbol )

   integer,          intent(in) :: n
   double precision, intent(in) :: xpts(*), ypts(*)
   integer,          intent(in) :: symbol

   ! Primitive routine to draw Graph Markers. The markers are drawn using
   ! some attributes (see below).
   !
   ! Arguments:
   !  N      (input)  : number of points to mark.
   !  XPTS   (input)  : world x-coordinates of the points.
   !  YPTS   (input)  : world y-coordinates of the points.
   !  SYMBOL (input)  : code number of the symbol to be drawn at each point:
   !
   !                     1..26   : new marker symbols (size = current
   !                               character-height)
   !                    -1..-26  : same markers (using abs(SYMBOL)) but
   !                               with a white border around the symbol.
   !
   !                    any other: ERROR
   !--
   ! 27-Nov-1986
   ! 17-Dec-1990 - Add polygons [PAH].
   ! 14-Mar-1997 - Optimization: use GRDOT1 [TJP].
   ! 29-Feb-2020 - Use now double precision instead of single precision.
   !  2-Apr-2020 - Update explanation in the header; fix the code for
   !               testing the number symbol. Generalized polygons are
   !               removed (see grmker).
   !  6-Apr-2020 - Calling syntax to GRMKER updated.
   !  8-Apr-2020 - Remove call to GRDOT1 (never used).
   ! 29-Oct-2021 - Added 5 new symbols. Total number is now 26 instead of 21.
   !-----------------------------------------------------------------------

   integer :: symb

   !------ end of declarations -- execution starts hereafter  ------

   if( n < 1 ) return

   symb = abs(symbol)

   call pgbbuf()

   if( 1 <= symb .and. symb <= 26 ) then
      ! second argument tells grmker to use world coordinates
      call grmker( symbol, n, xpts, ypts )
   else
      call grwarn('PGPT - invalid symbol number')
   end if

   call pgebuf()

end subroutine
