! PGPAGE -- Advance to new page (modified EC)

subroutine PGPAGE

   ! Advance plotter to a new page, always clearing the screen.  PGPAGE
   ! does not change the MFPLOT window or viewport (in normalized device
   ! coordinates); but note that if the size of the view-surface is changed
   ! externally (e.g., by a workstation window manager) then the size of
   ! the viewport is changed in proportion.
   !
   ! Arguments: none
   !--
   !  7-Feb-1983
   ! 23-Sep-1984 - Correct bug: call GRTERM at end (if flush mode set).
   ! 31-Jan-1985 - Make closer to Fortran-77.
   ! 19-Nov-1987 - Explicitly clear the screen if device is interactive;
   !               this restores the behavior obtained with older versions
   !               of GRPCKG.
   !  9-Feb-1988 - Move prompting into routine GRPROM.
   ! 11-Apr-1989 - Change name to PGPAGE.
   ! 10-Sep-1990 - Add identification labelling.
   ! 11-Feb-1992 - Check if device size has changed.
   !  3-Sep-1992 - Allow column ordering of panels.
   ! 17-Nov-1994 - Move identification to drivers.
   ! 23-Nov-1994 - Fix bug: character size not getting reset.
   ! 23-Jan-1995 - Rescale viewport if size of view surface  has changed.
   !  4-Feb-1997 - Bug fix; character size was not correctly indexed by
   !               device ID.
   ! 29-Feb-2020 - Use now double precision instead of single precision [EC].
   ! 11-Apr-2020 - Simplify extremely the routine, squizzing the subpanel
   !               feature, and the pgpfix test [EC].
   ! 15-Apr-2020 - Modified call to grsize: device resolution removed [EC].
   ! 16-Apr-2020 - Modified to take into account suppression of panels [EC].
   !-----------------------------------------------------------------------

   double precision :: xvp1, xvp2, yvp1, yvp2

   !------ end of declarations -- execution starts hereafter  ------

   ! Reset view surface size if it has changed.
   call grpage

   ! Get current viewport in Norm. Device Coords.
   call pgqvp( 0, xvp1, xvp2, yvp1, yvp2 )

   ! Reset character size.
   call pgsch(pgchsz(pgid))

   ! Reset viewport.
   call pgsvp( xvp1, xvp2, yvp1, yvp2 )

   ! Begin picture.
   call grbpic

end subroutine
