! PGOLIN -- Mark a set of points using the cursor

subroutine PGOLIN( maxpt, npt, x, y, symbol )

   integer :: maxpt, npt
   double precision :: x(*), y(*)
   integer :: symbol

   ! Interactive routine for user to enter data points by use of
   ! the cursor.  Routine allows user to Add and Delete points.  The
   ! points are returned in the order that they were entered (unlike
   ! PGNCUR).
   !
   ! Arguments:
   !  MAXPT  (input)  : maximum number of points that may be accepted.
   !  NPT    (in/out) : number of points entered; should be zero on
   !                    first call.
   !  X      (in/out) : array of x-coordinates.
   !  Y      (in/out) : array of y-coordinates.
   !  SYMBOL (input)  : code number of symbol to use for marking
   !                    entered points (see PGPT).
   !
   ! Note (1): The dimension of arrays X and Y must be greater than or
   ! equal to MAXPT.
   !
   ! Note (2): On return from the program, cursor points are returned in
   ! the order they were entered. Routine may be (re-)called with points
   ! already defined in X,Y (number in NPT), and they will be plotted
   ! first, before editing.
   !
   ! Note (3): User commands: the user types single-character commands
   ! after positioning the cursor: the following are accepted:
   ! A (Add)    - add point at current cursor location.
   ! D (Delete) - delete the last point entered.
   ! X (eXit)   - leave subroutine.
   !--
   !  4-Nov-1985 - New routine (adapted from PGNCUR) [TJP].
   ! 13-Dec-1990 - Change warnings to messages [TJP].
   !  7-Sep-1994 - Use PGBAND [TJP].
   !  2-Aug-1995 - Remove dependence on common block [TJP].
   ! 29-Feb-2020 - Use now double precision instead of single precision [EC].
   !-----------------------------------------------------------------------

   character*1 :: letter
   integer :: savcol
   double precision :: xp, yp, xref, yref
   double precision :: xblc, xtrc, yblc, ytrc

   !------ end of declarations -- execution starts hereafter  ------

   ! Save current color.
   call grqci(savcol)

   ! Put current points on screen.  Position cursor on last point,
   ! or in middle viewport if there are no current points.
   call pgqwin(xblc, xtrc, yblc, ytrc)
   if( npt /= 0 ) then
      call pgpt(npt,x,y,symbol)
      xp = x(npt)
      yp = y(npt)
   else
      xp = 0.5*(xblc+xtrc)
      yp = 0.5*(yblc+ytrc)
   end if

   ! Loop over cursor inputs.
10 xref = xp
   yref = yp
stop "don't use PGOLIN: not yet updated to PGBAND!"
!!      IF (PGBAND(0,1,XREF,YREF,XP,YP,LETTER).NE.1) RETURN
   if( letter == char(0) ) return
   call grtoup(letter,letter)

   ! A (ADD) command:
   if( letter == 'A' ) then
      if( npt >= maxpt ) then
         call grmsg('ADD ignored (too many points).')
      else
         npt = npt + 1
         x(npt) = xp
         y(npt) = yp
         call pgpt(1,x(npt),y(npt),symbol)
         call grterm
      end if

   ! D (DELETE) command:
   else if( letter == 'D' ) then
      if( npt <= 0 ) then
         call grmsg('DELETE ignored (there are no points left).')
      else
         call grsci(0)
         call pgpt(1,x(npt),y(npt),symbol)
         xp = x(npt)
         yp = y(npt)
         call grsci(savcol)
         call grterm
         npt = npt-1
      end if

   ! X (EXIT) command:
   else if( letter == 'X' ) then
!!      CALL GRETXT (removed)
      return

   ! Illegal command:
   else
      call grmsg('Commands are A (add), D (delete), X (exit).')
   end if

   goto 10

end subroutine
