! PGNPL -- Work out how many numerals there are in an integer

subroutine PGNPL( nmax, n, npl )

   integer :: nmax, n, npl

   !     Work out how many numerals there are in an integer for use with
   !     format statements.
   !     e.g.  N=280 => NPL=3,   N=-3 => NPL=2
   !
   !     Input:
   !       NMAX   :   If > 0, issue a warning that N is going to
   !                  exceed the format statement field size if NPL
   !                  exceeds NMAX
   !       N      :   Integer of interest
   !     Output:
   !       NPL    :   Number of numerals
   !
   !-
   !  20-Apr-1991 - New routine (Neil Killeen).
   !-----------------------------------------------------------------------

   if( n == 0 ) then
     npl = 1
   else
     npl = int(log10(real(abs(n)))) + 1
   end if
   if( n < 0 ) npl = npl + 1

   if( nmax > 0 .and. npl > nmax ) then
      call grwarn( 'PGNPL: output conversion error likely; '            &
                   //'number too big for format' )
   end if

end subroutine
