! PGLINE2 -- Draw a polyline (finite values, only for X11 device)

subroutine PGLINE2( n, xpts, ypts )

   integer,          intent(in) :: n
   double precision, intent(in) :: xpts(*), ypts(*)

   ! Same as PGLINE, but for X11 or NULL device.
   ! Here, we are sure that xpts(*) and ypts(*) contains finite values.
   !--
   !  1-Dec-2021 - Creation.
   ! 24-Mar-2023 - Forgot abs() when checking too large values.
   !-----------------------------------------------------------------------

   double precision, allocatable :: xp(:), yp(:)
   integer :: i
   logical :: int_Xlib_overflow

   allocate( xp(n), yp(n) )

   do i = 1, n
      xp(i) = xpts(i) * grxscl(grcide) + grxorg(grcide)
      yp(i) = ypts(i) * gryscl(grcide) + gryorg(grcide)
   end do

   ! Check if new device coordinates (xp,yp) are restricted to X11 values
   ! (quick exit as soon as a big value is found).
   int_Xlib_overflow = .false.
   do i = 1, n
      if( abs(xp(i)) > MFPLOT_SHORT_MAX ) then
         int_Xlib_overflow = .true.
         exit
      end if
      if( abs(yp(i)) > MFPLOT_SHORT_MAX ) then
         int_Xlib_overflow = .true.
         exit
      end if
   end do

   if( int_Xlib_overflow ) then

      do i = 1, n-1
         call grlin2( xp(i), yp(i), xp(i+1), yp(i+1) )
      end do

   else

      call grlin3( n, xp, yp )

   end if

end subroutine
