! PGLEN -- Find length of a string in a variety of units

subroutine PGLEN( units, string, lenx, leny )

   integer,          intent(in)  :: units
   character(len=*), intent(in)  :: string
   double precision, intent(out) :: lenx, leny

   ! Work out length of a string in x and y directions
   !
   !  UNITS (input):  4 => answer in world coordinates
   !                  5 => answer as a fraction of the current viewport size
   !
   !  STRING (input): String of interest
   !
   !  LENX  (output): Length of string in x direction
   !  LENY  (output): Length of string in y direction
   !--
   ! 15-Sep-1989 - New routine (Neil Killeen)
   ! 29-Feb-2020 - Use now double precision instead of single precision [EC].
   !  8-Apr-2020 - Restrict UNITS to 4 and 5; grlen call replaced by a call
   !               to grlen_ps_font.
   !-----------------------------------------------------------------------

   double precision :: d

   !------ end of declarations -- execution starts hereafter  ------

   ! Work out length of a string in absolute device coordinates (pixels)
   ! and then convert
   call grlen_ps_font( string, d )

   if( units == 4 ) then
      lenx = d / abs(pgxscl(pgid))
      leny = d / abs(pgyscl(pgid))
   else if( units == 5 ) then
      lenx = d / pgxlen(pgid)
      leny = d / pgylen(pgid)
   else
      call grwarn('PGLEN - Illegal value for UNITS')
   end if

end subroutine
