! PGERRY -- Vertical error bar

subroutine PGERRY( n, x, y1, y2, t )

   integer          :: n
   double precision :: x(*), y1(*), y2(*)
   double precision :: t

   ! Plot vertical error bars.
   ! This routine draws an error bar only; to mark the data point in
   ! the middle of the error bar, an additional call to PGPT or
   ! PGERRX is required.
   !
   ! Arguments:
   !  N      (input)  : number of error bars to plot.
   !  X      (input)  : world x-coordinates of the data.
   !  Y1     (input)  : world y-coordinates of top end of the
   !                    error bars.
   !  Y2     (input)  : world y-coordinates of bottom end of the
   !                    error bars.
   !  T      (input)  : length of terminals to be drawn at the ends
   !                    of the error bar, as a multiple of the default
   !                    length; if T = 0.0, no terminals will be drawn.
   !
   ! Note: the dimension of arrays X, Y1, and Y2 must be greater
   ! than or equal to N. If N is 1, X, Y1, and Y2 may be scalar
   ! variables or expressions, eg:
   !       CALL PGERRY(1,X,Y+SIGMA,Y-SIGMA)
   !--
   ! (6-Oct-1983)
   ! 31-Mar-1997 - Use pgtikl [TJP].
   ! 29-Feb-2020 - Use now double precision instead of single precision [EC].
   !-----------------------------------------------------------------------

   integer :: i
   double precision :: xtik, ytik

   !------ end of declarations -- execution starts hereafter  ------

   if( n < 1 ) return

   call pgbbuf()

   call pgtikl(t, xtik, ytik)
   do  i = 1, n
       if( t /= 0.0d0 ) then
           call grmova( x(i)-xtik, y1(i) )
           call grlina( x(i)+xtik, y1(i) )
       end if
       call grmova( x(i),y1(i) )
       call grlina( x(i),y2(i) )
       if( t /= 0.0d0 ) then
           call grmova( x(i)-xtik, y2(i) )
           call grlina( x(i)+xtik, y2(i) )
       end if
   end do

   call pgebuf()

end subroutine
