! PGERRX -- Horizontal error bar

subroutine PGERRX( n, x1, x2, y, t )

   integer          :: n
   double precision :: x1(*), x2(*), y(*)
   double precision :: t

   ! Plot horizontal error bars.
   ! This routine draws an error bar only; to mark the data point in
   ! the middle of the error bar, an additional call to PGPT or
   ! PGERRY is required.
   !
   ! Arguments:
   !  N      (input)  : number of error bars to plot.
   !  X1     (input)  : world x-coordinates of lower end of the
   !                    error bars.
   !  X2     (input)  : world x-coordinates of upper end of the
   !                    error bars.
   !  Y      (input)  : world y-coordinates of the data.
   !  T      (input)  : length of terminals to be drawn at the ends
   !                    of the error bar, as a multiple of the default
   !                    length; if T = 0.0, no terminals will be drawn.
   !
   ! Note: the dimension of arrays X1, X2, and Y must be greater
   ! than or equal to N. If N is 1, X1, X2, and Y may be scalar
   ! variables, or expressions, eg:
   !       CALL PGERRX(1,X-SIGMA,X+SIGMA,Y)
   !--
   ! (6-Oct-1983)
   ! 31-Mar-1997 - Use pgtikl [TJP[.
   ! 29-Feb-2020 - Use now double precision instead of single precision [EC].
   !-----------------------------------------------------------------------

   integer :: i
   double precision :: xtik, ytik

   !------ end of declarations -- execution starts hereafter  ------

   if( n < 1 ) return

   call pgbbuf()

   call pgtikl(t, xtik, ytik)
   do  i = 1, n
       if( t /= 0.0d0 ) then
           call grmova( x1(i), y(i)-ytik )
           call grlina( x1(i), y(i)+ytik )
       end if
       call grmova( x1(i), y(i) )
       call grlina( x2(i), y(i) )
       if( t /= 0.0d0 ) then
           call grmova( x2(i), y(i)-ytik )
           call grlina( x2(i), y(i)+ytik )
       end if
   end do

   call pgebuf()

end subroutine
