! PGERR1 -- Horizontal or vertical error bar

subroutine PGERR1( dir, x, y, e, t )

   integer          :: dir
   double precision :: x, y, e
   double precision :: t

   ! Plot a single error bar in the direction specified by DIR.
   ! This routine draws an error bar only; to mark the data point at
   ! the start of the error bar, an additional call to PGPT is required.
   ! To plot many error bars, use PGERRB.
   !
   ! Arguments:
   !  DIR    (input)  : direction to plot the error bar relative to
   !                    the data point.
   !                    One-sided error bar:
   !                      DIR is 1 for +X (X to X+E);
   !                             2 for +Y (Y to Y+E);
   !                             3 for -X (X to X-E);
   !                             4 for -Y (Y to Y-E).
   !                    Two-sided error bar:
   !                      DIR is 5 for +/-X (X-E to X+E);
   !                             6 for +/-Y (Y-E to Y+E).
   !  X      (input)  : world x-coordinate of the data.
   !  Y      (input)  : world y-coordinate of the data.
   !  E      (input)  : value of error bar distance to be added to the
   !                    data position in world coordinates.
   !  T      (input)  : length of terminals to be drawn at the ends
   !                    of the error bar, as a multiple of the default
   !                    length; if T = 0.0, no terminals will be drawn.
   !--
   ! 31-Mar-1997 - New routine [TJP].
   ! 29-Feb-2020 - Use now double precision instead of single precision [EC].
   !-----------------------------------------------------------------------

   double precision :: XTIK, YTIK, XX, YY

   !------ end of declarations -- execution starts hereafter  ------

   if( dir < 1 .or. dir > 6 ) return

   call pgbbuf()

   ! Determine terminal length.
   call pgtikl(t, xtik, ytik)

   ! Draw terminal at starting point if required.
   if( dir == 5 ) then
      xx = x-e
      yy = y
   else if( dir == 6 ) then
      xx = x
      yy = y-e
   else
      xx = x
      yy = y
   end if
   if( t /= 0.0d0 ) then
      if( dir == 5 ) then
         call grmova( xx, yy-ytik )
         call grlina( xx, yy+ytik )
      else if( dir == 6 ) then
         call grmova( xx-xtik, yy )
         call grlina( xx+xtik, yy )
      end if
   end if

   ! Draw the error bar itself.
   call grmova(xx,yy)
   if( dir == 1 .or. dir == 5 ) then
      xx = x+e
      yy = y
   else if( dir == 2 .or. dir == 6 ) then
      xx = x
      yy = y+e
   else if( dir == 3 ) then
      xx = x-e
      yy = y
   else if( dir == 4 ) then
      xx = x
      yy = y-e
   end if
   call grlina(xx,yy)

   ! Draw terminal at end point.
   if( t /= 0.0d0 ) then
      if( mod(dir,2) == 1 ) then
         call grmova( xx, yy-ytik )
         call grlina( xx, yy+ytik )
      else
         call grmova( xx-xtik, yy )
         call grlina( xx+xtik, yy )
      end if
   end if

   call pgebuf()

end subroutine
