! PGEBUF -- End batch of output (buffer) -- Useful only for the X11 driver

subroutine PGEBUF

   ! *** Useful only for the X11 driver ***

   ! A call to PGEBUF marks the end of a batch of graphical output begun
   ! with the last call of PGBBUF.  PGBBUF and PGEBUF calls should always
   ! be paired. Each call to PGBBUF increments a counter, while each call
   ! to PGEBUF decrements it. When the counter reaches 0, the batch of
   ! output is written on the output device.
   !
   ! If the environment variable MFPLOT_DEBUG is set to a value greater
   ! or equal to 2 by the user, grterm is always called, whatever the buffer
   ! level is.
   !
   ! Arguments: none
   !--
   ! 21-Nov-1985 - New routine [TJP].
   ! 14-Apr-2020 - Simplify the code.
   !  8-Apr-2021 - Effect of this routine is now conditionned by the
   !               environment variable MFPLOT_DEBUG.
   !-----------------------------------------------------------------------

   pgblev(pgid) = max(0, pgblev(pgid) - 1)

   if( pgblev(pgid) == 0 .or. MFPLOT_DEBUG >= 2 ) then
      ! Flush buffer.
      ! (actually used only in the X11 driver: copy of the modified area
      !  of the pixmap on the screen)
      call grterm
   end if

end subroutine
