! PGCONL -- Label contour map of a 2D data array

subroutine PGCONL( a, idim, jdim, i1, i2, j1, j2, c, tr, label, intval, minint )

   integer :: idim, jdim, i1, j1, i2, j2, intval, minint
   double precision :: a(idim,jdim), c, tr(6)
   character(len=*) :: label

   ! Label a contour map drawn with routine PGCONT. Routine PGCONT should
   ! be called first to draw the contour lines, then this routine should be
   ! called to add the labels. Labels are written at intervals along the
   ! contour lines, centered on the contour lines with lettering aligned
   ! in the up-hill direction. Labels are opaque, so a part of the under-
   ! lying contour line is obscured by the label. Labels use the current
   ! attributes (character height, line width, color index, character
   ! font).
   !
   ! The first 9 arguments are the same as those supplied to PGCONT, and
   ! should normally be identical to those used with PGCONT. Note that
   ! only one contour level can be specified; to label more contours, call
   ! PGCONL for each level.
   !
   ! The Label is supplied as a character string in argument LABEL.
   !
   ! The spacing of labels along the contour is specified by parameters
   ! INTVAL and MININT. The routine follows the contour through the
   ! array, counting the number of cells that the contour crosses. The
   ! first label will be written in the MININT'th cell, and additional
   ! labels will be written every INTVAL cells thereafter. A contour
   ! that crosses less than MININT cells will not be labelled. Some
   ! experimentation may be needed to get satisfactory results; a good
   ! place to start is INTVAL=20, MININT=10.
   !
   ! Arguments:
   !  A      (input) : data array.
   !  IDIM   (input) : first dimension of A.
   !  JDIM   (input) : second dimension of A.
   !  I1, I2 (input) : range of first index to be contoured (inclusive).
   !  J1, J2 (input) : range of second index to be contoured (inclusive).
   !  C      (input) : the level of the contour to be labelled (one of the
   !                   values given to PGCONT).
   !  TR     (input) : array defining a transformation between the I,J
   !                   grid of the array and the world coordinates.
   !                   The world coordinates of the array point A(I,J)
   !                   are given by:
   !                     X = TR(1) + TR(2)*I + TR(3)*J
   !                     Y = TR(4) + TR(5)*I + TR(6)*J
   !                   Usually TR(3) and TR(5) are zero - unless the
   !                   coordinate transformation involves a rotation or
   !                   shear.
   !  LABEL  (input) : character strings to be used to label the specified
   !                   contour. Leading and trailing blank spaces are
   !                   ignored.
   !  INTVAL (input) : spacing along the contour between labels, in
   !                   grid cells.
   !  MININT (input) : contours that cross less than MININT cells
   !                   will not be labelled.
   !--
   !  5-May-1994 - New routine; this routine is virtually identical to
   !               PGCONT, but calls PGCONX with a different external
   !               routine [TJP].
   !  4-Feb-1997 - PGCONX requires an array argument, not scalar [TJP].
   !-- E.C. modif.
   ! 25-Dec-2013 - As PGCLAB is a global (module) variable, and is only used
   !               by the current routine and 'pgcl()', we add the effective
   !               length in a new global variable : PGCLAB_LEN
   ! 29-Feb-2020 - Use now double precision instead of single precision [EC].
   !-----------------------------------------------------------------------

   integer :: i
   double precision :: cl(1)

   !------ end of declarations -- execution starts hereafter  ------

   gr_minus_sign_math_mode = .true.

   ! Save TRANS matrix and other parameters.
   do i = 1, 6
      trans(i) = tr(i)
   end do
   pgcint = intval
   pgcmin = minint
   pgclab = label
   ! not trimmed, because we sometimes want to add one leading or
   ! trailing blank.
   pgclab_len = len(label)

   ! Use PGCONX with external function PGCL.
   cl(1) = c
   call pgconx( a, idim, jdim, i1, i2, j1, j2, cl, 1, pgcl )

   gr_minus_sign_math_mode = .false.

end subroutine
