! PGCN01 -- Auxiliary routine used by PGCNSC (and possibly others...)

subroutine PGCN01( z, mx, my, ia, ib, ja, jb, z0, plot,                 &
                   flags, is, js, sdir )

   integer :: mx, my, ia, ib, ja, jb, is, js, sdir
   logical :: flags(maxemx,maxemy,2)
   double precision :: z(mx,*), z0
   external plot

   ! Support routine for PGCNSC. This routine draws a continuous contour,
   ! starting at the specified point, until it either crosses the edge of
   ! the array or closes on itself.
   !--
   ! 29-Feb-2020 - Use now double precision instead of single precision.
   !  3-Oct-2021 - Fixed the arbitrary choice when a cell contains four
   !               crossing-points in itself. Same algo as PGCONS_EC.
   !-----------------------------------------------------------------------

   integer, parameter :: up=1, down=2, left=3, right=4
   integer :: i, j, ii, jj, dir
   double precision :: x, y, startx, starty
   double precision :: x_up, y_up, d2_up, x_down, y_down, d2_down,      &
                       x_left, y_left, d2_left, x_right, y_right, d2_right


   !------ end of declarations -- execution starts hereafter  ------

   i = is
   j = js
   dir = sdir
   ii = 1+i-ia
   jj = 1+j-ja
   if( dir == up .or. dir == down ) then
      x = dble(i) + (z0-z(i,j))/(z(i+1,j)-z(i,j))
      y = dble(j)
   else
      x = dble(i)
      y = dble(j) + (z0-z(i,j))/(z(i,j+1)-z(i,j))
   end if

   ! Move to start of contour and record starting point.
   call plot( 0, x, y, z0 )
   startx = x
   starty = y

   ! We have reached grid-point (I,J) going in direction DIR (UP, DOWN,
   ! LEFT, or RIGHT). Look at the other three sides of the cell we are
   ! entering to decide where to go next. It is important to look to the
   ! two sides before looking straight ahead, in order to avoid self-
   ! intersecting contours. If all 3 sides have unused crossing-points,
   ! the cell is "degenerate" and we have to decide which of two possible
   ! pairs of contour segments to draw; at present we make an arbitrary
   ! choice. If we have reached the edge of the array, we have
   ! finished drawing an unclosed contour. If none of the other three
   ! sides of the cell have an unused crossing-point, we must have
   ! completed a closed contour, which requires a final segment back to
   ! the starting point.

10 continue
   ii = 1 + i - ia
   jj = 1 + j - ja
   goto (11, 12, 13, 14), dir

   !
   !   j   +-------+
   !       |       |
   !       |       |
   !       |       |
   !  j-1  +-------+
   !      i-1      i

   ! dir = up
11 continue
   flags(ii,jj,1) = .false.
   if( j == jb ) then
      return
   end if
   if( flags(ii,jj,2) ) then ! left
      if( flags(ii+1,jj,2) ) then ! right
         ! choix left ou right doit dépendre de la distance
         x_left = dble(i)
         y_left = dble(j) + (z0-z(i,j))/(z(i,j+1)-z(i,j))
         d2_left = (x-x_left)**2 + (y-y_left)**2
         i = i+1
         x_right = dble(i)
         y_right = dble(j) + (z0-z(i,j))/(z(i,j+1)-z(i,j))
         d2_right = (x-x_right)**2 + (y-y_right)**2
         if( d2_left < d2_right ) then
            i = i-1
            dir = left
         else
            dir = right
         end if
      else
         dir = left
      end if
      goto 20
   end if
   if( flags(ii+1,jj,2) ) then
      dir = right
      i = i+1
      goto 20
   end if
   if( flags(ii,jj+1,1) ) then
      j = j+1
      goto 25
   end if
   goto 30

   ! dir = down
12 continue
   flags(ii,jj,1) = .false.
   if( j == ja ) then
      return
   end if
   if( flags(ii+1,jj-1,2) ) then ! right
      if( flags(ii,jj-1,2) ) then ! left
         i = i+1
         j = j-1
         x_right = dble(i)
         y_right = dble(j) + (z0-z(i,j))/(z(i,j+1)-z(i,j))
         i = i-1
         d2_right = (x-x_right)**2 + (y-y_right)**2
         x_left = dble(i)
         y_left = dble(j) + (z0-z(i,j))/(z(i,j+1)-z(i,j))
         d2_left = (x-x_left)**2 + (y-y_left)**2
         if( d2_right < d2_left ) then
            dir = right
            i = i+1
         else
            dir = left
         end if
      else
         dir = right
         i = i+1
         j = j-1
      end if
      goto 20
   end if
   if( flags(ii,jj-1,2) ) then
      dir = left
      j = j-1
      goto 20
   end if
   if( flags(ii,jj-1,1) ) then
      j = j-1
      goto 25
   end if
   goto 30

   ! dir = left
13 continue
   flags(ii,jj,2) = .false.
   if( i == ia ) then
      return
   end if
   if( flags(ii-1,jj,1) ) then ! down
      if( flags(ii-1,jj+1,1) ) then ! up
         i = i-1
         x_down = dble(i) + (z0-z(i,j))/(z(i+1,j)-z(i,j))
         y_down = dble(j)
         d2_down = (x-x_down)**2 + (y-y_down)**2
         j = j+1
         x_up = dble(i) + (z0-z(i,j))/(z(i+1,j)-z(i,j))
         y_up = dble(j)
         d2_up = (x-x_up)**2 + (y-y_up)**2
         if( d2_down < d2_up ) then
            dir = down
            j = j-1
         else
            dir = up
         end if
      else
         dir = down
         i = i-1
      end if
      goto 25
   end if
   if( flags(ii-1,jj+1,1) ) then
      dir = up
      i = i-1
      j = j+1
      goto 25
   end if
   if( flags(ii-1,jj,2) ) then
      i = i-1
      goto 20
   end if
   goto 30

   ! dir = right
14 continue
   flags(ii,jj,2) = .false.
   if( i == ib ) then
      return
   end if
   if( flags(ii,jj+1,1) ) then ! up
      if( flags(ii,jj,1) ) then ! down
         j = j+1
         x_up = dble(i) + (z0-z(i,j))/(z(i+1,j)-z(i,j))
         y_up = dble(j)
         d2_up = (x-x_up)**2 + (y-y_up)**2
         j = j-1
         x_down = dble(i) + (z0-z(i,j))/(z(i+1,j)-z(i,j))
         y_down = dble(j)
         d2_down = (x-x_down)**2 + (y-y_down)**2
         if( d2_up < d2_down ) then
            dir = up
            j = j+1
         else
            dir = down
         end if
      else
         dir = up
         j = j+1
      end if
      goto 25
   end if
   if( flags(ii,jj,1) ) then
      dir = down
      goto 25
   end if
   if( flags(ii+1,jj,2) ) then
      i = i+1
      goto 20
   end if
   goto 30

   ! Draw a segment of the contour.
20 x = dble(i)
   y = dble(j) + (z0-z(i,j))/(z(i,j+1)-z(i,j))
!!print "(A,G0.4,1X,G0.4)", "(DBG:)         (I,J) = ", x, y
   call plot( 1, x, y, z0 )
   goto 10

25 x = dble(i) + (z0-z(i,j))/(z(i+1,j)-z(i,j))
   y = dble(j)
!!print "(A,G0.4,1X,G0.4)", "(DBG:)         (I,J) = ", x, y
   call plot( 1, x, y, z0 )
   goto 10

   ! Close the contour and go look for another one.
30 continue
!!print "(A,G0.4,1X,G0.4)", "(DBG:)         (x,y) = ", x, y
   call plot( 1, startx, starty, z0 )

end subroutine
