! PGCLOS -- Close the selected graphics device

subroutine PGCLOS

   ! Close the currently selected graphics device. After the device has
   ! been closed, either another open device must be selected with PGSLCT
   ! or another device must be opened with PGOPEN before any further
   ! plotting can be done. If the call to PGCLOS is omitted, some or all
   ! of the plot may be lost.
   !
   ! [This routine was added to MFPLOT in Version 5.1.0. Older programs
   ! use PGEND instead.]
   !
   ! Arguments: none
   !--
   ! 22-Dec-1995 - New routine, derived from the old PGEND.
   ! 10-Apr-2020 - Interactive prompt with the user is removed [EC].
   ! 11-Mar-2025 - Adapted to USER_TICKS (see PGBOX) [EC].
   !-----------------------------------------------------------------------

   ! Reset to some important default
   USER_TICKS(pgid) = .false.

   call grclos

   pgdevs(pgid) = 0
   pgid = 0

end subroutine
