! PGCL -- Contour labelling

subroutine PGCL( k, x, y, z )

   integer, intent(in) :: k
   double precision,    intent(in) :: x, y, z

   ! MFPLOT (internal routine): Label one contour segment (for use by
   ! PGCONX).
   !
   ! Arguments:
   !
   ! K (input, integer): if K=0, move the pen to (X,Y); if K=1, draw
   !       a line from the current position to (X,Y); otherwise
   !       do nothing.
   ! X (input, real): X world-coordinate of end point.
   ! Y (input, real): Y world-coordinate of end point.
   ! Z (input, real): the value of the contour level, not used by PGCL.
   !--
   !  5-May-1994 - New routine [TJP]
   !  7-Mar-1995 - Correct error in angle; do not draw labels outside
   !               window [TJP].
   ! 28-Aug-1995 - Check arguments of atan2 [TJP].
   !-- E.C. modif.
   ! 25-Dec-2013 - Added an argument to the call of 'pgptxt()' to avoid
   !               the removing of leading and trailing blanks.
   ! 29-Feb-2020 - Use now double precision instead of single precision [EC].
   !-----------------------------------------------------------------------

   double precision :: xx, yy, xc, yc, xv1, xv2, yv1, yv2, xl, xr, yb, yt
   double precision :: xn, yn
   double precision :: angle, xo, yo, xp, yp, dindx, dindy, xbox(4), ybox(4)
   integer :: tb
   integer, save :: i = 0

   !------ end of declarations -- execution starts hereafter  ------

   ! transform to world coordinates
   xx = trans(1) + trans(2)*x + trans(3)*y
   yy = trans(4) + trans(5)*x + trans(6)*y

   if( k == 0 ) then
      ! start of contour: reset segment counter
      i = 0
   else
      ! increment segment counter and check whether this
      ! segment should be labelled
      i = mod(i+1,pgcint)
      if( i == pgcmin ) then
         ! find center of this segment (XC, YC)
         call grqpos(xp, yp)
         xc = (xx+xp)*0.5d0
         yc = (yy+yp)*0.5d0
         ! find slope of this segment (ANGLE)
         call pgqvp(1, xv1, xv2, yv1, yv2)
         call pgqwin(xl, xr, yb, yt)
         angle = 0.0d0
         if( xr /= xl .and. yt /= yb ) then
            dindx = (xv2 - xv1) / (xr - xl)
            dindy = (yv2 - yv1) / (yt - yb)
            if( yy-yp /= 0.0d0 .or. xx-xp /= 0.0d0 )                    &
               angle = rad_to_deg*atan2((yy-yp)*dindy, (xx-xp)*dindx)
         end if
         ! check whether point is in window
         xn = (xc-xl)/(xr-xl)
         yn = (yc-yb)/(yt-yb)
         if( xn >= 0.0d0 .and. xn <= 1.0d0 .and.                        &
             yn >= 0.0d0 .and. yn <= 1.0d0 ) then
            ! save current text background and set to erase
            call pgqtbg(tb)
            call pgstbg(0)
            ! find bounding box of label
            call pgqtxt(xc, yc, angle, 0.5d0, pgclab, xbox, ybox)
            xo = 0.5d0*(xbox(1)+xbox(3))
            yo = 0.5d0*(ybox(1)+ybox(3))
            ! plot label with bounding box centered at (XC, YC)
            call pgptxt( 2.0d0*xc-xo, 2.0d0*yc-yo, angle, 0.5d0, 0.0d0, &
                         pgclab(1:pgclab_len), to_be_trimmed=.false. )
            ! restore text background
            call pgstbg(tb)
         end if
      end if
   end if
   call grmova(xx,yy)

end subroutine
