! PGCIRC -- Draw a circle, using fill-area attributes

subroutine PGCIRC( xcent, ycent, radius )

   double precision, intent(in) :: xcent, ycent, radius

   ! Draw a circle. The action of this routine depends
   ! on the setting of the Fill-Area Style attribute. If Fill-Area Style
   ! is SOLID (the default), the interior of the circle is solid-filled
   ! using the current Color Index. If Fill-Area Style is HOLLOW, the
   ! outline of the circle is drawn using the current line attributes
   ! (color index, line-style, and line-width).
   !
   ! Arguments:
   !  XCENT  (input)  : world x-coordinate of the center of the circle.
   !  YCENT  (input)  : world y-coordinate of the center of the circle.
   !  RADIUS (input)  : radius of circle (world coordinates).
   !--
   ! 26-Nov-1992 - [TJP].
   ! 20-Sep-1994 - Adjust number of points according to size [TJP].
   ! 29-Feb-2020 - Use now double precision instead of single precision [EC].
   !-----------------------------------------------------------------------

   integer, parameter :: maxpts = 72

   integer :: npts, i, radpix
   double precision :: angle
   double precision :: x(maxpts), y(maxpts)

   !------ end of declarations -- execution starts hereafter  ------

   radpix = nint( radius*max(pgxscl(pgid), pgyscl(pgid)) )
   npts = max( 8, min(maxpts, radpix) )

   do i = 1, npts
      angle = i*360.0d0/dble(npts)*deg_to_rad
      x(i) = xcent + radius*cos(angle)
      y(i) = ycent + radius*sin(angle)
   end do

!### TODO: The implementation should depend on the device:
!            1) NULL device: do nothing
!            2)  X11 device: use Bézier curves (4 quaters is common)
!            3)  EPS device: use the 'arc' built-in operator of PS language
!            4)  PDF device: idem 2
   call pgpoly( npts, x, y )

end subroutine
