! PGARRO -- Draw an arrow

subroutine PGARRO( x1, y1, x2, y2, clipping )

   double precision, intent(in) :: x1, y1, x2, y2
   logical,          intent(in) :: clipping

   ! Draw an arrow from the point with world-coordinates (X1,Y1) to
   ! (X2,Y2). The size of the arrowhead at (X2,Y2) is determined by
   ! the current character size set by routine PGSCH. The default size
   ! is 1/40th of the smaller of the width or height of the view surface.
   ! The appearance of the arrowhead (shape and solid or open) is
   ! controlled by routine PGSAH.
   !
   ! Arguments:
   !  X1, Y1 (input)  : world coordinates of the tail of the arrow.
   !  X2, Y2 (input)  : world coordinates of the head of the arrow.
   !--
   !  7-Feb-1992 - Keith Horne @ STScI / TJP.
   ! 13-Oct-1992 - Use arrowhead attributes; scale (TJP).
   ! 29-Feb-2020 - Use now double precision instead of single precision.
   !-----------------------------------------------------------------------

   character(len=12) :: type
   integer :: length

   integer :: ahfs, fs
   double precision :: dx, dy, xv1, xv2, yv1, yv2, xl, xr, yb, yt, dindx, dindy
   double precision :: xinch, yinch, rinch, ca, sa, so, co, yp, xp, ym, xm, dhx, dhy
   double precision :: px(4), py(4)
   double precision :: ahangl, ahvent, semang, ch, dh, xs1, xs2, ys1, ys2

   logical :: clipping_disabled

   double precision :: rbuf(1)
   integer :: ibuf(1), lchr
   character(len=1) :: chr

   !------ end of declarations -- execution starts hereafter  ------

   clipping_disabled = .false.
   if( .not. clipping ) then
      call pgqinf( "TYPE", type, length )
      if( type == 'EPS' ) then
         call EPS_no_clip_beg()
      else if( type == 'PDF' ) then
         call PDF_no_clip_beg()
      else ! X11 or NULL device
         if( CLIPPING_IN_AXES ) then
            ibuf(1) = 0 ! no clipping
            call grexec( grgtyp, SET_CLIPPING, rbuf, ibuf, chr, lchr ) ! set clipping
            clipping_disabled = .true.
         end if
      end if
   end if

   call pgbbuf()

!### TODO: beaucoup d'expressions pourraient être calculées une seule fois
!          puis conservées dans des variables statiques :
!            Used values: ahfs = 1 (fill-area style: solid)
!                         ahangl = 45 deg.
!                         ahvent = 0.3
!                         semang = ahangl/2.0d0*deg_to_rad
!                         so = sin(semang)
!                         co = -cos(semang)
!                         0.50d0*(1.0d0-ahvent) = 0.35
!
!    D'autre part, par définition de PGQVSZ : xs1 = ys1 = 0   (toujours)
!
!    xs2 = grxmxa(grcide)/pgxpin(pgid)
!    ys2 = grymxa(grcide)/pgypin(pgid)
!
!    xv2 - xv1 = pgxlen(pgid)/pgxpin(pgid)
!    yv2 - yv1 = pgylen(pgid)/pgypin(pgid)
!
!
   call pgqah( ahfs, ahangl, ahvent )
   call pgqfs( fs )
   call pgsfs( ahfs )
   dx = x2 - x1 ! wld
   dy = y2 - y1
   call pgqch( ch )
   call pgqvsz( 1, xs1, xs2, ys1, ys2 )
   ! Length of arrowhead: 1/40th of the smaller of the height or
   ! width of the view surface, scaled by character height.
   dh = ch*min(abs(xs2),abs(ys2))/40.0d0 ! inch
   call grmova( x2, y2 )

   ! Is there to be an arrowhead?
   if( dh > 0.0d0 ) then
      if( dx /= 0.0d0 .or. dy /= 0.0d0 ) then
         ! Get x and y scales
         call pgqvp( 1, xv1, xv2, yv1, yv2 )
         call pgqwin( xl, xr, yb, yt )
         if( xr /= xl .and. yt /= yb) then
            dindx = (xv2 - xv1) / (xr - xl) ! inch / wld
            dindy = (yv2 - yv1) / (yt - yb)
            dhx = dh / dindx ! wld
            dhy = dh / dindy
            ! Unit vector in direction of the arrow
            xinch = dx * dindx ! inch
            yinch = dy * dindy
            rinch = sqrt( xinch*xinch + yinch*yinch )
            ca = xinch / rinch
            sa = yinch / rinch
            ! Semiangle in radians
            semang = ahangl/2.0d0*deg_to_rad ! rad
            so = sin(semang)
            co = -cos(semang)
            ! Vector back along one edge of the arrow
            xp = dhx*(ca*co - sa*so) ! wld
            yp = dhy*(sa*co + ca*so)
            ! Vector back along other edge of the arrow
            xm = dhx*(ca*co + sa*so) ! wld
            ym = dhy*(sa*co - ca*so)
            ! Draw the arrowhead
            px(1) = x2
            py(1) = y2
            px(2) = x2 + xp
            py(2) = y2 + yp
            px(3) = x2 + 0.50d0*(xp+xm)*(1.0d0-ahvent)
            py(3) = y2 + 0.50d0*(yp+ym)*(1.0d0-ahvent)
            px(4) = x2 + xm
            py(4) = y2 + ym
            call pgpoly( 4, px, py )
            call grmova( px(3), py(3) )
         end if
      end if
   end if
   call grlina( x1, y1 )
   call grmova( x2, y2 )
   call pgsfs( fs )

   call pgebuf()

   if( .not. clipping ) then
      if( type == 'EPS' ) then
         call EPS_no_clip_end()
      else if( type == 'PDF' ) then
         call PDF_no_clip_end()
      else ! X11 or NULL device
         if( clipping_disabled ) then
            ! restore the clipping, which should be the default
            ibuf(1) = 1 ! clipping at viewport
            call grexec( grgtyp, SET_CLIPPING, rbuf, ibuf, chr, lchr ) ! set clipping
         end if
      end if
   end if

end subroutine
