! GRXRGB -- convert HLS color to RGB color

subroutine GRXRGB( h, l, s, r, g, b )

   double precision, intent(in)  :: h, l, s
   double precision, intent(out) :: r, g, b
   !------ API end ------

   ! GRPCKG: Convert a color specified in the HLS color model to one in
   ! the RGB model.  This is a support routine: no graphics I/O occurs.
   ! The inverse transformation is accomplished with routine GRXHLS.
   ! Reference: SIGGRAPH Status Report of the Graphic Standards Planning
   ! Committee, Computer Graphics, Vol.13, No.3, Association for
   ! Computing Machinery, New York, NY, 1979.
   !
   ! Arguments:
   !
   ! H,L,S (real, input): hue (0 to 360), lightness (0 to 1.0), and
   !       saturation (0 to 1.0).
   ! R,G,B (real, output): red, green, blue color coordinates, each in the
   !       range 0.0 to 1.0.
   !--
   !  2-Jul-1984 - New routine [TJP].
   ! 29-Sep-1994 - Take H module 360 [TJP].
   ! 26-Nov-1996 - Force results to be in range (avoid rounding error
   !               problems on some machines) [TJP].
   ! 29-Feb-2020 - Use now double precision instead of single precision [EC].
   !-----------------------------------------------------------------------

   double precision :: ma, mi, hm

   !------ end of declarations -- execution starts hereafter  ------

   hm = mod(h, 360.0)
   if( hm < 0.0 ) hm = hm + 360.0
   if( l <= 0.5 ) then
      ma = l*(1.0+s)
   else
      ma = l + s - l*s
   end if
   mi = 2.0*l-ma

! R component
   if( hm < 60.0 ) then
      r = mi + (ma-mi)*hm/60.0
   else if( hm < 180.0 ) then
      r = ma
   else if( hm < 240.0 ) then
      r = mi + (ma-mi)*(240.0-hm)/60.0
   else
      r = mi
   end if

! G component
   if( hm < 120.0 ) then
      g = mi
   else if( hm < 180.0 ) then
      g = mi + (ma-mi)*(hm-120.0)/60.0
   else if( hm < 300.0 ) then
      g = ma
   else
      g = mi + (ma-mi)*(360.0-hm)/60.0
   end if

! B component
   if( hm < 60.0 .or. hm >= 300.0 ) then
      b = ma
   else if( hm < 120.0 ) then
      b = mi + (ma-mi)*(120.0-hm)/60.0
   else if( hm < 240.0 ) then
      b = mi
   else
      b = mi + (ma-mi)*(hm-240.0)/60.0
   end if

   r = min(1.0d0, max(0.0d0,r))
   g = min(1.0d0, max(0.0d0,g))
   b = min(1.0d0, max(0.0d0,b))

end subroutine
