! GRVCT0 -- draw line segments or dots

subroutine GRVCT0( mode, points, x, y )

   integer          :: mode, points
   double precision :: x(points), y(points)
   !------ API end ------

   ! GRPCKG (internal routine): Draw a line or a set of dots. This
   ! is the same as GRVECT, but without device selection. It can be used to
   ! draw a single line-segment, a continuous series of line segments, or
   ! one or more single dots (pixels).
   !
   ! Arguments:
   !
   ! MODE (input, integer): if MODE=1, a series of line segments is drawn,
   !       starting at the current position, moving to X(1),Y(1), ... and
   !       ending at X(POINTS),Y(POINTS).
   !       If MODE=2, the first vector is blanked, so the line starts at
   !       X(1),Y(1).
   ! ABSXY (input, logical): if TRUE, the coordinates are absolute device
   !       coordinates; if FALSE, they are world coordinates and the
   !       scaling transformation is applied.
   ! POINTS (input, integer): the number of coordinate pairs.
   ! X, Y (input, real arrays, dimensioned POINTS or greater): the
   !       X and Y coordinates of the points.
   !--
   ! (1-Feb-1983)
   ! 29-Feb-2020 - Use now double precision instead of single precision [EC].
   !  6-Apr-2020 - Removed ABSXY argument (FALSE in all calling routines);
   !               calling syntax to GRTXY0 updated [EC].
   !  8-Apr-2020 - Removed MODE=3, never used [EC].
   ! 16-Mar-2021 - Changed name of GRTXY0 to GR_WLD_TO_DEV [EC].
   !-----------------------------------------------------------------------

   integer :: i
   double precision :: xcur, ycur

   !------ end of declarations -- execution starts hereafter  ------

   if( mode < 1 .or. 2 < mode ) then
      call grwarn('GRVCT0 - Bad value for MODE.')
      return
   end if

   if( mode == 1 ) then
      call gr_wld_to_dev( x(1), y(1), xcur, ycur )
      call grlin0(xcur, ycur)
   else if( mode == 2 ) then
      call gr_wld_to_dev( x(1), y(1), grxpre(grcide), grypre(grcide) )
   end if

   do i = 2, points
      call gr_wld_to_dev( x(i), y(i), xcur, ycur )
      call grlin0(xcur, ycur)
   end do

end subroutine
