! GRTOUP -- convert character string to upper case
!           + copy of function to_upper and to_lower (from FML)

subroutine GRTOUP( dst, src )

   character(len=*), intent(in)  :: src
   character(len=*), intent(out) :: dst
   !------ API end ------

   ! GRPCKG (internal routine): convert character string to upper case.
   !
   ! Arguments:
   !  DST    (output) : output string (upper case).
   !  SRC    (input)  : input string to be converted.
   !--
   ! 1988-Jan-18 (TJP)
   !-----------------------------------------------------------------------

   integer :: i, n, nchi, ncho, nch

   !------ end of declarations -- execution starts hereafter  ------

   nchi = len(src)
   ncho = len(dst)
   nch = min(nchi, ncho)
   do i = 1, nch
       n = ichar(src(i:i))
       if( 97 <= n .and. n <= 122 ) then
          dst(i:i) = char(n - 32)
       else
          dst(i:i) = char(n)
       end if
   end do
   if( ncho > nchi ) dst(nchi+1:ncho) = " "

end subroutine
!_______________________________________________________________________
!
function to_upper( keyword )

   character(len=*), intent(in) :: keyword
   character(len=len_trim(keyword)) :: to_upper

   ! just for ASCII-7 bits
   integer :: ishift
   integer :: i, ipos
   character :: c

   !------ end of declarations -- execution starts hereafter  ------

   ishift = ichar("A")-ichar("a")
   to_upper = ""

   do i = 1, len_trim(keyword)
      c = keyword(i:i)
      ipos = ichar(c) - ichar("a") + 1
      if( 1 <= ipos .and. ipos <= 26 ) then
         ! 'c' is in lower case
         to_upper(i:i) = char( ichar(c) + ishift )
      else
         to_upper(i:i) = c
      end if
   end do

end function to_upper
!_______________________________________________________________________
!
function to_lower( keyword )

   character(len=*), intent(in) :: keyword
   character(len=len_trim(keyword)) :: to_lower

   ! just for ASCII-7 bits
   integer :: ishift
   integer :: i, ipos
   character :: c

   !------ end of declarations -- execution starts hereafter  ------

   ishift = ichar("a")-ichar("A")
   to_lower = ""

   do i = 1, len_trim(keyword)
      c = keyword(i:i)
      ipos = ichar(c) - ichar("A") + 1
      if( 1 <= ipos .and. ipos <= 26 ) then
         ! 'c' is in upper case
         to_lower(i:i) = char( ichar(c) + ishift )
      else
         to_lower(i:i) = c
      end if
   end do

end function to_lower
