! GRSMS -- set marker size

subroutine GRSMS( markersize )

   double precision, intent(in) :: markersize
   !------ API end ------

   ! GRPCKG: Set the size of marker symbols.
   !
   ! Argument:
   !
   ! MARKERSIZE (real, input): size, a positive number
   !--
   !  2-Apr-2020 - New routine [EC].
   !-----------------------------------------------------------------------

   logical :: thick_line
   double precision :: s

   character(len=4) :: type
   logical :: inter

   !------ end of declarations -- execution starts hereafter  ------

   ! Check that graphics is active.
   if( grcide < 1 ) then
      call grwarn('GRSMS - no graphics device is active.')
      return
   end if

   ! Check that requested line-width is valid.
   s = markersize
   if( s < 0. ) then
      call grwarn('GRSMS - invalid marker-size requested.')
      s = 1.0d0
   end if

   call grqtyp( type, inter )
   ! Ignore the request if the markersize is unchanged.
   if( type == 'EPS' .or. type == 'PDF' ) then
      ! For an EPS, be sure that we are in the save Graphic State.
      ! So, define LAST_MARKERSIZE_IS_VALID = .true. at each change of size
      ! but cancel this boolean if there is a PostScript 'grestore' command.
      if( LAST_MARKERSIZE_IS_VALID ) then
         if( s == abs(grmsiz(grcide)) ) then
            return
         end if
      end if
   else
      if( s == abs(grmsiz(grcide)) ) then
         return
      end if
   end if

   ! No specific grexec call: the actual use of the marker size is done
   ! inside grmker().

   ! Save the current linewidth.
   grmsiz(grcide) = s

   LAST_MARKERSIZE_IS_VALID = .true.

end subroutine
