! GRSLW -- set line width

subroutine GRSLW( width )

   double precision, intent(in) :: width
   !------ API end ------

   ! GRPCKG: Set the line width for subsequent plotting on the current
   ! device. The actual line width obtained depends on the device
   ! resolution and is 0.005 inches times the value of argument WIDTH.
   !
   ! Argument:
   !
   ! WIDTH (real, input): width, a positive number
   !--
   !  1-Feb-1983 - [TJP].
   !  3-Jun-1984 - Add GMFILE device [TJP].
   ! 28-Aug-1984 - Correct bug in GMFILE: redundant SET_LINEWIDTH;
   !               commands were not being filtered out [TJP].
   ! 26-May-1987 - Add GREXEC support [TJP].
   ! 11-Jun-1987 - Remove built-in devices [TJP].
   ! 31-May-1989 - Increase maximum width from 21 to 201 [TJP].
   !
   ! 15-Dec-2006 - Width is now a real instead of integer
   !  2-Aug-2018 - Conditional quick return added.
   ! 29-Feb-2020 - Use now double precision instead of single precision.
   ! 15-Apr-2021 - Simplify code because all devices support hardware thick
   !               lines.
   !-----------------------------------------------------------------------

   double precision :: w, rbuf(1)
   integer :: ibuf(1), lchr
   character :: chr

   character(len=4) :: type
   logical :: inter

   !------ end of declarations -- execution starts hereafter  ------

   ! Check that graphics is active.
   if( grcide < 1 ) then
      call grwarn('GRSLW - no graphics device is active.')
      return
   end if

   ! Check that requested line-width is valid.
   w = width
   if( w < 0. ) then
      call grwarn('GRSLW - invalid line-width requested.')
      w = 1.0d0
   end if

   ! Correction: for all devices, we multiply the linewidth by a factor
   ! such that nint(linewidth) corresponds to the X11 width in pixels...
   w = w * 2.25d0

   call grqtyp( type, inter )
   ! Try to ignore the request if the linewidth is unchanged...
   if( type == 'EPS' .or. type == 'PDF' ) then
      ! For EPS and PDF, be sure that we are in the save Graphic State.
      ! So, define LAST_LINEWIDTH_IS_VALID = .true. at each change of width
      ! but cancel this boolean if there is a PostScript 'grestore' command.
      if( LAST_LINEWIDTH_IS_VALID ) then
         if( w == grwidt(grcide) ) then
            return
         end if
      end if
   else
      if( w == grwidt(grcide) ) then
         return
      end if
   end if

   ! Send the appropriate command to the device driver.
   if( grpltd(grcide) ) then
      rbuf(1) = w
      call grexec( grgtyp, SET_LINE_WIDTH, rbuf, ibuf, chr, lchr )
   end if

   ! Save the current linewidth.
   grwidt(grcide) = w

   if( type == 'EPS' .or. type == 'PDF' ) then
      LAST_LINEWIDTH_IS_VALID = .true.
   end if

end subroutine
