! GRSLCT -- select active output device

subroutine GRSLCT( ident )

   integer, intent(in) :: ident
   !------ API end ------

   ! GRPCKG: Check that IDENT is a valid plot identifier, and select the
   ! corresponding plot as the current plot. All subsequent plotting will
   ! be directed to this device until the assignment is changed by another
   ! call to GRSLCT.
   !
   ! Argument:
   !
   ! IDENT (input, integer): the identifier of the plot to be selected, as
   !       returned by GROPEN.
   !--
   ! (1-Feb-1983)
   !  5-Aug-1986 - Add GREXEC support [AFT].
   !  4-Jun-1987 - Skip action if no change in ID [TJP].
   ! 29-Feb-2020 - Use now double precision instead of single precision.
   ! 23-Mar-2023 - Add a reset of global parameters
   !-----------------------------------------------------------------------

   double precision :: rbuf(1)
   integer :: ibuf(1), lchr
   character(len=1) :: chr

   !------ end of declarations -- execution starts hereafter  ------

   if( ident < 1 .or. grimax < ident .or. grstat(ident) == 0 ) then
      call grwarn('GRSLCT - invalid plot identifier.')
   else if( ident == grcide ) then
      grgtyp = grtype(ident)
      return
   else
      grcide = ident
      grgtyp = grtype(ident)
      ibuf(1)= grunit(grcide)

      LAST_COLOR_IS_VALID       = .false.
      LAST_LINEWIDTH_IS_VALID   = .false.
      LAST_LINESTYLE_IS_VALID   = .false.
      LAST_FONT_ATTRIB_IS_VALID = .false.
      LAST_MARKERSIZE_IS_VALID  = .false.
      call grexec( grgtyp, SELECT_PLOT, rbuf, ibuf, chr, lchr )
   end if

end subroutine
