! GRSIZE -- inquire device size

subroutine GRSIZE( xszdev, yszdev )

   integer, intent(out) :: xszdev, yszdev
   !------ API end ------

   ! GRPCKG : obtain the drawing area, i.e. the whole window size minus
   !          1/4" margins (user-callable routine).
   !--
   ! (1-Feb-1983)
   !  5-Aug-1986 - Add GREXEC support [AFT].
   ! 29-Feb-2020 - Use now double precision instead of single precision.
   ! 11-Apr-2020 - Suppress call to driver with OPCODE=2; removed argument
   !               IDENT.
   ! 15-Apr-2020 - Remove output of device resolution; seems not relevant to
   !               redefine here.
   !  1-Apr-2021 - Change type of argument to integer.
   !-----------------------------------------------------------------------

   integer :: ibuf(4), lchr
   double precision :: rbuf(1)
   character :: chr

   !------ end of declarations -- execution starts hereafter  ------

   ibuf(1) = 0 ! no need to wait a few tens of milliseconds
   rbuf(1) = 1. ! request of the full drawing area
   call grexec( grgtyp, GET_DEF_SIZE, rbuf, ibuf, chr, lchr )
   xszdev = ibuf(2)
   yszdev = ibuf(4)

end subroutine
