! GRSCR -- set color representation

subroutine GRSCR( ci, cr, cg, cb )

   integer,          intent(in) :: ci
   double precision, intent(in) :: cr, cg, cb
   !------ API end ------

   ! GRPCKG: SET COLOUR REPRESENTATION -- define the colour to be associated
   ! with a colour index.  Ignored for devices which do not support variable
   ! colour or intensity.  On monochrome output devices (e.g. VT125 terminals
   ! with monochrome monitors), the monochrome intensity is computed from the
   ! specified Red, Green, Blue intensities as 0.30*R + 0.59*G + 0.11*B, as in
   ! US color television systems, NTSC encoding. Note that most devices do not
   ! have an infinite range of colours or monochrome intensities available; the
   ! nearest available colour is used.
   !
   ! Arguments:
   !
   ! CI (integer, input): colour index. If the colour index is outside the range
   !       available on the device, the call is ignored. Colour index 0 applies
   !       to the background colour.
   ! CR, CG, CB (real, input): red, green, and blue intensities,
   !       in range 0.0 to 1.0.
   !--
   ! 20-Feb-1984 - [TJP].
   !  5-Jun-1984 - Add GMFILE device [TJP].
   !  2-Jul-1984 - Add REGIS device [TJP].
   !  2-Oct-1984 - Change use of map tables in Regis [TJP].
   ! 11-Nov-1984 - Add code for /TK [TJP].
   !  1-Sep-1986 - Add GREXEC support [AFT].
   ! 21-Feb-1987 - If needed, calls begin picture [AFT].
   ! 31-Aug-1994 - Suppress call of begin picture [TJP].
   !  1-Sep-1994 - Use common data [TJP].
   ! 26-Jul-1995 - Fix bug: some drivers would ignore a change to the
   !               current color [TJP].
   !--------------
   ! 06-Jan-2006 - Delete last test for CI, because this has been already
   !               checked in MUESLI calling routine.
   ! 29-Feb-2020 - Use now double precision instead of single precision.
   !-----------------------------------------------------------------------

   integer :: ibuf(3), lchr
   double precision :: rbuf(3)
   character :: chr

   !------ end of declarations -- execution starts hereafter  ------

   if( grcide < 1 ) then
      call grwarn('GRSCR - Specified workstation is not open.')
   else if( cr < 0.0 .or. cg < 0.0 .or. cb < 0.0 .or.                &
            cr > 1.0 .or. cg > 1.0 .or. cb > 1.0 ) then
      call grwarn('GRSCR - Colour is outside range [0,1].')
      pause '(MFPLOT/grscr:) pause for debugging purpose...'
   else
      ibuf(1) = ci
      rbuf(1) = cr
      rbuf(2) = cg
      rbuf(3) = cb
      call grexec( grgtyp, SET_COL_REPRES, rbuf, ibuf, chr, lchr )
      ! If this is the current color, reselect it in the driver.
      if( ci == grccol(grcide) ) then
         ibuf(1) = ci
         ibuf(3) = 1
         call grexec( grgtyp, SELECT_COL_IND, rbuf, ibuf, chr, lchr )
      end if
   end if

end
