! GRSCI -- set color index

subroutine GRSCI( ic )

   integer, intent(in) :: ic
   !------ API end ------

   ! GRPCKG: Set the color index for subsequent plotting. Calls to GRSCI
   ! are ignored for monochrome devices. The default color index is 1,
   ! usually white on a black background for video displays or black on a
   ! white background for printer plots. The color index is an integer in
   ! the range 0 to a device-dependent maximum. Color index 0 corresponds
   ! to the background color; lines may be "erased" by overwriting them
   ! with color index 0.
   !
   ! Color indices 0-7 are predefined as follows: 0 = black (background
   ! color), 1 = white (default), 2 = red, 3 = green, 4 = blue, 5 = cyan
   ! (blue + green), 6 = magenta (red + blue), 7 = yellow (red + green).
   ! The assignment of colors to color indices can be changed with
   ! subroutine GRSCR (set color representation).
   !
   ! Argument:
   !
   ! IC (integer, input): the color index to be used for subsequent
   !       plotting on the current device (in range 0-255). If the
   !       index exceeds the device-dependent maximum, the result is
   !       device-dependent.
   !--
   ! 11-Apr-1983 - [TJP].
   !  3-Jun-1984 - Add GMFILE device [TJP].
   ! 13-Jun-1984 - Add code for TK4100 devices [TJP].
   !  2-Jul-1984 - Add code for RETRO and VT125 (REGIS) devices [TJP].
   !  2-Oct-1984 - Change REGIS to improve VT240 behavior [TJP].
   ! 22-Dec-1984 - Add PRTX, TRILOG, VERS and VV devices [TJP].
   ! 29-Jan-1985 - Add HP2648 device [KS/TJP].
   !  5-Aug-1986 - Add GREXEC support [AFT].
   ! 21-Feb-1987 - Delays setting color if picture not open [AFT].
   ! 11-Jun-1987 - Remove built-in devices [TJP].
   ! 31-May-1989 - Add check for valid color index [TJP].
   !  1-Sep-1994 - Use common data [TJP].
   !
   !  6-Jan-2006 - Delete test for COLOR, because this has been already
   !               checked in MUESLI calling routine.
   !  2-Aug-2018 - Quick return check now takes into account a change of
   !               "gsave-grestore" block.
   ! 29-Feb-2020 - Use now double precision instead of single precision [EC].
   ! 18-Jun-2025 - Add the test about LAST_COLOR_IS_VALID to avoid a
   !               quick return. This concerns change of figure, when
   !               multiple windows are in use.
   !-----------------------------------------------------------------------

   integer :: color, ibuf(3), lchr
   double precision :: rbuf(1)
   character*1 :: chr

   character(len=4) :: type
   logical :: inter

   !------ end of declarations -- execution starts hereafter  ------

   ! Error if no workstation is open.
   if( grcide < 1 ) then
      call grwarn('GRSCI - no graphics device is active.')
      return
   end if

   color = ic

   call grqtyp( type, inter )
   ! The quick return was a good idea, but for PDF, color management
   ! is more complex (rg/=RG, for Fill or Stroke)
   if( type /= 'PDF' ) then
!### TODO: voir comment affiner cela pour économiser des sélections identiques
!          de couleurs... 2 booléens, alors ? pas suffisant, ici, on ne sait
!          pas si la couleur va être pour Stroke ou pour Fill, ou pour les
!          deux !
! Le problème doit alors être traité en amont (comme dans 'pgconx_ec').
      ! If no change to color index is requested, take no action.
      if( type == 'EPS' ) then
         ! For an EPS, be sure that we are in the same Graphic State.
         ! So, define LAST_COLOR_IS_VALID = .true. at each change of color
         ! but cancel this boolean if there is a PostScript 'grestore' command.
         if( LAST_COLOR_IS_VALID ) then
            if( color == grccol(grcide) ) return
         end if
      else
      ! Below, the test is required, because in case of change of figure,
      ! we could obtain wrong colors!
      if( LAST_COLOR_IS_VALID ) then
         if( color == grccol(grcide) ) return
      end if

      end if
   end if

   ! If the workstation is in "picture open" state, send command to the driver.
   if( grpltd(grcide) ) then
      ibuf(1) = color
      ibuf(3) = 1
      call grqtyp( type, inter )
      if( type == 'PDF' ) then
         ! For PDF, send also the aim of the coloring (for Stroke, or for Fill)
         !  gr_pdf_color_intent = 1 for Stroke, 2 for Fill, 3 for both (Arrow)
         ibuf(2) = gr_pdf_color_intent
         ibuf(3) = 2
      end if
      call grexec( grgtyp, SELECT_COL_IND, rbuf, ibuf, chr, lchr )
      ! Save the current color index.
      grccol(grcide) = color
   end if

   LAST_COLOR_IS_VALID = .true.

end subroutine
