! GRRECT -- rectangle (stroked or filled)

subroutine GRRECT( x0, y0, x1, y1, filled )

   double precision, intent(in) :: x0, y0, x1, y1
   logical,          intent(in) :: filled
   !------ API end ------

   ! GRPCKG: Fill a rectangle with solid color. The rectangle is defined
   ! by the (x,y) world coordinates of its lower left and upper right
   ! corners; the edges are parallel to the coordinate axes.
   ! The rectangle is clipped or not at the edge of the window, according
   ! to the value of the module logical variable CLIPPING_IN_AXES
   !
   ! Arguments:
   !
   ! X0, Y0 : world coordinates of one corner of the rectangle.
   ! X1, Y1 : world coordinates of the opposite corner of the rectangle.
   ! FILLED : the rectangle may be filled or simply stroked.
   !--
   ! 23-Mar-1988 - [TJP].
   ! 18-Jan-1991 - Code moved from GRRECT to GRREC0 so that it can also be
   !               used by GRPXRE
   !  9-Feb-2020 - Added the optional arg. 'clipping' to authorize
   !               the drawing out of the window. For solid fill only!
   ! 29-Feb-2020 - Use now double precision instead of single precision.
   !  6-Apr-2020 - Calling syntax to GRTXY0 updated.
   ! 12-Mar-2021 - Removed the optional arg. 'clipping', because GRRECT
   !               is called only by PGRECT.
   ! 16-Mar-2021 - Changed name of GRTXY0 to GR_WLD_TO_DEV.
   ! 30-Nov-2021 - Quick return is now done only if the clipping is set.
   ! 15-Dec-2021 - Added the argument 'filled'.
   !-----------------------------------------------------------------------

   double precision :: xbl, ybl, xtr, ytr
   double precision :: xmin, ymin, xmax, ymax

   !------ end of declarations -- execution starts hereafter  ------

   if( grcide < 1 ) return

   ! Convert to device coordinates.
   call gr_wld_to_dev( x0, y0, xbl, ybl )
   call gr_wld_to_dev( x1, y1, xtr, ytr )

   ! Reorder the vertices
   xmin = min( xbl, xtr )
   xmax = max( xbl, xtr )
   ymin = min( ybl, ytr )
   ymax = max( ybl, ytr )

   ! Quick return if possible (using device coordinates); very efficient
   ! for interactive zoom, when a redraw of all grobjs is made during
   ! pan or zoom...
   if( CLIPPING_IN_AXES ) then
      if( xmax < grxmin(grcide) ) return
      if( xmin > grxmax(grcide) ) return
      if( ymax < grymin(grcide) ) return
      if( ymin > grymax(grcide) ) return
   end if

   ! Do the real work
   call grrec0( xmin, ymin, xmax, ymax, filled )

end subroutine
