! GRREC0 -- fill a rectangle (device coordinates)

subroutine GRREC0( x0, y0, x1, y1, filled )

   double precision, intent(in) :: x0, y0, x1, y1
   logical,          intent(in) :: filled
   !------ API end ------

   ! GRPCKG: Fill a rectangle with solid color.  The rectangle
   ! is defined by the (x,y) device coordinates of its lower left and
   ! upper right corners; the edges are parallel to the coordinate axes.
   ! X0 is guaranteed to be <= X1 and Y0 <= Y1. The rectangle possibly
   ! extends beyond the clipping boundaries
   !
   ! Arguments:
   !
   ! X0, Y0 (input, real): device coordinates of the BL corner of the
   !                       rectangle.
   ! X1, Y1 (input, real): device coordinates of the TR corner of the
   !                       rectangle.
   !--
   ! 23-Mar-1988 - [TJP].
   ! 18-Jan-1991 - Code moved from GRRECT to GRREC0 so that it can also be
   !               used by GRPXRE.
   !  1-Sep-1994 - Suppress driver call [TJP].
   !  4-Dec-1995 - Avoid use of real variable as do-loop index [TJP].
   ! 28-Sep-2018 - Added a conditional clipping, according the value of
   !               the module logical variable CLIPPING_IN_AXES.
   ! 29-Feb-2020 - Use now double precision instead of single precision.
   ! 12-Mar-2021 - Simplified the code: one make the assumption that the
   !               selected device supports 'hardware rectangle' (this is
   !               true for PostScript since Level 2 release).
   !               Fixed the quick return, which must be done only when
   !               clipping is off.
   !               Also, do nothing if the device coordinates are equal
   !               along  the x- or the y-axis.
   ! 14-Mar-2021 - Clipping is suppressed (made in the drivers); also
   !               Quick Return has been moved in another routine.
   ! 14-Apr-2021 - Take care of integer overflow in the X11 driver
   !               (In Xlib, XPoint coordinates are 'short int').
   ! 15-Dec-2021 - Added the argument 'filled'.
   !-----------------------------------------------------------------------

   character(len=32) :: dev_typ
   logical :: ldummy

   double precision :: rbuf(1)
   integer :: ibuf(4), lchr
   character :: chr

   !------ end of declarations -- execution starts hereafter  ------

   if( .not. grpltd(grcide) ) call grbpic

   call grqtyp( dev_typ, ldummy )
   if( trim(dev_typ) == "XWINDOW" ) then
      ! Overflow in integers may lead to a change of sign; in such a case
      ! some drawn lines may appear as wrong. Device coordinates must be
      ! restricted to [−32,767, +32,767], which is the range for the XPoint
      ! coordinates in Xlib. See also the 'restrict_to_short' function in
      ! the MOD_GRPLOT module.
      ibuf(1) = restrict_to_short(x0)
      ibuf(2) = restrict_to_short(y0)
      ibuf(3) = restrict_to_short(x1)
      ibuf(4) = restrict_to_short(y1)
   else ! NULL, EPS or PDF
      ibuf(1) = nint(x0)
      ibuf(2) = nint(y0)
      ibuf(3) = nint(x1)
      ibuf(4) = nint(y1)
   end if

   if( filled ) then
      call grexec( grgtyp, RECT_FILL, rbuf, ibuf, chr, lchr )
   else ! stroked
      call grexec( grgtyp, RECT_DRAW, rbuf, ibuf, chr, lchr )
   end if

end subroutine
