! GRQTYP -- inquire current device type

subroutine GRQTYP( type, inter )

   character(len=*), intent(out) :: type
   logical,          intent(out) :: inter
   !------ API end ------

   ! GRPCKG: obtain the device type of the currently selected graphics
   ! device, and determine whether or not it is an interactive device.
   !
   ! Arguments:
   !
   ! TYPE (output): receives the device type, as a character string,
   !                e.g. 'PRINTRONIX', 'TRILOG', 'VERSATEC', etc.
   !                The character string should have a length of at least 8
   !                to ensure that the type is unique.
   ! INTER (output): receives the value .TRUE. if the device is
   !                 interactive, .FALSE. otherwise.
   !--
   ! (23-May-1983)
   !  5-Aug-1986 - Add GREXEC support [AFT].
   ! 18-Jan-1993 - Return type only, not description [TJP].
   !  1-Sep-1994 - Get capabilities from common [TJP].
   ! 29-Feb-2020 - Use now double precision instead of single precision [EC].
   !-----------------------------------------------------------------------

   double precision :: rbuf(1)
   integer :: ibuf(1), lchr
   character(len=32) :: chr

   !------ end of declarations -- execution starts hereafter  ------

   if( grcide < 1 ) then
      call grwarn('GRQTYP - no graphics device is active.')
      type = 'null'
      inter = .false.
   else
      call grexec( grgtyp, GET_DEV_NAME, rbuf, ibuf, chr, lchr )
      lchr = index(chr,' ')
      type = chr(:lchr)
      inter = grgcap(grcide)(1:1) == 'I'
   end if

end subroutine
