! GRQLS -- inquire current line-style

subroutine GRQLS( istyle, dash_pattern_period )

   integer, intent(out)           :: istyle
   integer, intent(out), optional :: dash_pattern_period
   !------ API end ------

   ! GRPCKG: obtain the line-style of the current graphics device and,
   ! optionally, the dash pattern period in device coordinates.
   !
   ! Argument:
   !  ISTYLE: the current line-style code.
   !  DASH_PATTERN_PERIOD: the dash pattern period in use in the driver.
   !--
   ! (1-Feb-1983)
   !-----------------------------------------------------------------------

   double precision :: rbuf(1)
   integer :: ibuf(1), lchr
   character :: chr

   !------ end of declarations -- execution starts hereafter  ------

   if( grcide < 1 ) then
      call grwarn('GRQLS - no graphics device is active.')
      istyle = 1
   else
      istyle = grstyl(grcide)
   end if

   if( present(dash_pattern_period) ) then
      call grexec( grgtyp, GET_DASH_PERIOD, rbuf, ibuf, chr, lchr )
      dash_pattern_period = ibuf(1)
   end if

end subroutine
