! GRQDT -- inquire current device and type

subroutine GRQDT( device )

   character(len=*) :: device
   !------ API end ------

   ! GRPCKG: obtain the name and type of the current graphics device.
   !
   ! Argument:
   !
   ! DEVICE (output, character): receives the device name and type of the
   !       currently active device in the form 'device/type'; this is a
   !       valid string for input to GROPEN.
   !--
   !  1-Feb-1983
   ! 19-Feb-1988 - Add quotes if necessary.
   !-----------------------------------------------------------------------

   character*14 :: type
   logical :: junk
   integer :: l

   !------ end of declarations -- execution starts hereafter  ------

   if( grcide < 1 ) then
      call grwarn('GRQDT - no graphics device is active.')
      device = '/NULL'
   else
      call grqtyp(type,junk)
      l = grfnln(grcide)
      if( l /= 0 ) then
         device = '/'//type
      else if( index(grfile(grcide)(1:l), '/') == 0 ) then
         device = grfile(grcide)(1:l)//'/'//type
      else
         device = '"'//grfile(grcide)(1:l)//'"/'//type
      end if
   end if

end subroutine
