! GRQCR -- inquire color representation

subroutine GRQCR( ci, cr, cg, cb )

   integer, intent(in) :: ci
   double precision    :: cr, cg, cb
   !------ API end ------

   ! Return the color representation (red, green, blue intensities)
   ! currently associated with the specified color index. This may be
   ! different from that requested on some devices.
   !
   ! Arguments:
   !
   ! CI (integer, input): color index.
   ! CR, CG, CB (real, output): red, green, and blue intensities,
   !                            in range 0.0 to 1.0.
   !--
   !  7-Sep-1994 - Rewrite [TJP].
   ! 29-Feb-2020 - Use now double precision instead of single precision [EC].
   !-----------------------------------------------------------------------

   integer :: ibuf(1), lchr
   double precision :: rbuf(3)
   character :: chr

   !------ end of declarations -- execution starts hereafter  ------

   cr = 1.0
   cg = 1.0
   cb = 1.0
   if( grcide < 1 ) then
      ! no device open: return white
      call grwarn('GRQCR: no plot device is open.')
   else if( grgcap(grcide)(9:9) /= 'Y') then
      ! devices that don't allow query color representation:
      ! return black for ci 0, white for all others
      if( ci == 0 ) then
         cr = 0.0
         cg = 0.0
         cb = 0.0
      end if
   else
      ibuf(1) = ci
      ! query device driver; treat invalid ci as 1
      if( ci < grmnci(grcide) .or. grmxci(grcide) < ci ) then
         call grwarn('GRQCR: invalid color index')
         ibuf(1) = 1
      end if
      lchr = 0
      call grexec( grgtyp, GET_COL_REPRES, rbuf, ibuf, chr, lchr )
      if( ibuf(1) /= 3 ) then
         call grwarn('GRSCR: device driver error')
      else
         cr = rbuf(1)
         cg = rbuf(2)
         cb = rbuf(3)
      end if
   end if

end subroutine
