! GRPOCL -- polygon clip

subroutine GRPOCL( n, px, py, edge, val, maxout, nout, qx, qy )

   integer          :: n, nout, edge, maxout
   double precision :: px(*), py(*), qx(*), qy(*)
   double precision :: val
   !------ API end ------

   ! Clip a polygon against a rectangle: Sutherland-Hodgman algorithm.
   ! this routine must be called four times to clip against each of the
   ! edges of the rectangle in turn.
   !
   ! Arguments:
   !
   ! N (input, integer): the number of vertices of the polygon (at least
   !       3).
   ! PX, PY (input, real arrays, dimension at least N): world coordinates
   !       of the N vertices of the input polygon.
   ! EDGE (input, integer):
   !     1: clip against left edge,   X > XMIN=VAL
   !     2: clip against right edge,  X < XMAX=VAL
   !     3: clip against bottom edge, Y > YMIN=VAL
   !     4: clip against top edge,    Y < YMIN=VAL
   ! VAL  (input, real): coordinate value of current edge.
   ! MAXOUT (input, integer): maximum number of vertices allowed in
   !     output polygon (dimension of QX, QY).
   ! NOUT (output, integer): the number of vertices in the clipped polygon.
   ! QX, QY (output, real arrays, dimension at least MAXOUT): world
   !       coordinates of the NOUT vertices of the output polygon.
   !--
   ! 19-Sep-1994 - [TJP].
   ! 27-Feb-1996 - Fix bug: overflow if coordinates are large [TJP].
   ! 11-Jul-1996 - Fix bug: left and bottom edges disappeared when precisely
   !               on edge [Remko Scharroo]
   ! 29-Feb-2020 - Use now double precision instead of single precision [EC].
   !-----------------------------------------------------------------------

   integer :: i
   double precision :: fx, fy, sx, sy

   !------ end of declarations -- execution starts hereafter  ------

   nout = 0
   do i = 1 , n
      if( i == 1 ) then
         ! save first point
         fx = px(i)
         fy = py(i)
      else if( (edge ==1 .or. edge ==2) .and.                           &
               (sign(1.0d0,px(i)-val) /= sign(1.0d0,sx-val)) ) then
         ! SP intersects this edge: output vertex at intersection
         nout = nout+1
         if( nout <= maxout ) then
            qx(nout) = val
            qy(nout) = sy + (py(i)-sy)*((val-sx)/(px(i)-sx))
         end if
      else if( (edge == 3 .or. edge == 4) .and.                         &
               (sign(1.0d0,py(i)-val) /= sign(1.0d0,sy-val)) ) then
         ! SP intersects this edge: output vertex at intersection
         nout = nout+1
         if( nout <= maxout ) then
            qx(nout) = sx + (px(i)-sx)*((val-sy)/(py(i)-sy))
            qy(nout) = val
         end if
      end if
      sx = px(i)
      sy = py(i)
      if( (edge == 1 .and. sx >= val) .or.                              &
          (edge.eq.2 .and. sx <= val) .or.                              &
          (edge.eq.3 .and. sy >= val) .or.                              &
          (edge.eq.4 .and. sy <= val) ) then
         ! output visible vertex S
         nout = nout + 1
         if( nout <= maxout ) then
             qx(nout) = sx
             qy(nout) = sy
         end if
      end if
   end do
   ! Does SF intersect edge?
   if( (edge == 1 .or. edge == 2) .and.                                 &
       (sign(1.0d0,sx-val) /= sign(1.0d0,fx-val)) ) then
      nout = nout+1
      if( nout <= maxout ) then
         qx(nout) = val
         qy(nout) = sy + (fy-sy)*((val-sx)/(fx-sx))
      end if
   else if( (edge == 3 .or. edge == 4) .and.                            &
            (sign(1.0d0,sy-val) /= sign(1.0d0,fy-val)) ) then
      nout = nout+1
      if( nout <= maxout ) then
         qy(nout) = val
         qx(nout) = sx + (fx-sx)*((val-sy)/(fy-sy))
      end if
   end if

end subroutine
