! GRPAGE -- end picture

subroutine GRPAGE

   ! GRPCKG: Advance the plotting area to a new page. For video devices,
   ! this amounts to erasing the screen; for hardcopy devices, the plot
   ! buffer is written to the output file followed by a form-feed to
   ! advance the paper to the start of the next page.
   !
   ! Arguments: none.
   !--
   !  3-Jun-1983 - [TJP].
   ! 18-Feb-1984 - Remove unnecessary 'T' initialization of VT125, and add
   !               S(G1) for Rainbow REGIS [TJP].
   !  1-Jun-1984 - Add type GMFILE [TJP].
   !  2-Jul-1984 - Change initialization of VT125 for color [TJP].
   ! 13-Jul-1984 - Move initialization of VT125 and Grinnell to GROPEN [TJP].
   ! 19-Oct-1984 - Add VV device [TJP].
   ! 29-Jan-1985 - Add HP2648 terminal [KS/TJP].
   !  5-Aug-1986 - Add GREXEC support [AFT].
   ! 21-Feb-1987 - Fix GREXEC end picture sequence [AFT].
   ! 11-Jun-1987 - Remove built-in devices [TJP].
   ! 11-Feb-1992 - Update view surface size: it may have changed! [TJP].
   !  5-Jan-1993 - But only if GRSETS has not been called! [TJP]
   ! 29-Feb-2020 - Use now double precision instead of single precision [EC].
   ! 11-Apr-2020 - Removed test on GRADJU [EC].
   !-----------------------------------------------------------------------

   integer :: ibuf(4), lchr
   double precision :: rbuf(1)
   character :: chr

   !------ end of declarations -- execution starts hereafter  ------

   ! Flush the buffer.
   call grterm

   ! End picture.
   call grepic

   ! Update the view surface size: it may have changed (on windowing devices)
   ibuf(1) = 0 ! no need to wait a few tens of milliseconds
   rbuf(1) = 1. ! request of the full drawing area
   call grexec( grgtyp, GET_DEF_SIZE, rbuf, ibuf, chr, lchr )
   grxmxa(grcide) = ibuf(2)
   grymxa(grcide) = ibuf(4)

end subroutine
