! GROPEN -- open device for graphics (other than X11)

integer function GROPEN( type, dummy, file, ident )

   integer,          intent(in)  :: type, dummy
   character(len=*), intent(in)  :: file
   integer,          intent(out) :: ident
   !------ API end ------

   ! GRPCKG: assign a device and prepare for plotting.  GROPEN must be
   ! called before all other calls to GRPCKG routines.
   !
   ! Returns:
   !
   ! GROPEN (output, integer): 1 => success, any other value
   !       indicates a failure (usually the value returned will
   !       be a VMS error code). In the event of an error, a
   !       message will be sent to the standard error unit.
   !
   ! Arguments:
   !
   ! TYPE (input, integer): default device type (integer code).
   ! DUMMY (input, integer): not used at present.
   ! FILE (input, character): plot specifier, of form "device/type".
   ! IDENT (output, integer): plot identifier to be used in later
   !       calls to GRPCKG.
   !
   !  1-Jun-1984 - [TJP].
   !  2-Jul-1984 - Change to call GRSLCT [TJP].
   ! 13-Jul-1984 - Add device initialization [TJP].
   ! 23-Jul-1984 - Add /APPEND qualifier.
   ! 19-Oct-1984 - Add VV device [TJP].
   ! 26-Dec-1984 - Obtain default file name from common [TJP].
   ! 29-Jan-1985 - Add HP2648 device [KS/TJP].
   !  5-Aug-1986 - Add GREXEC support [AFT].
   ! 12-Oct-1986 - Fix bug causing GREXEC to erase screen [AFT].
   !  3-Jun-1987 - Remove declaration of exit handler [TJP].
   ! 15-Dec-1988 - Standardize [TJP].
   ! 25-Jun-1989 - Remove code that removes spaces from the device name
   !               [TJP].
   ! 26-Nov-1990 - [TJP].
   !  5-Jan-1993 - [TJP].
   !  1-Sep-1994 - Store device capabilities in common for later use [TJP].
   ! 17-Apr-1995 - Zero-length string fix [TJP].
   !  6-Jun-1995 - Explicitly initialize GRSTAT [TJP].
   ! 29-Apr-1996 - Moved initialization into GRINIT [TJP].
   ! 12-Jul-1999 - Fix bug [TJP].
   ! 29-Feb-2020 - Use now double precision instead of single precision [EC].
   !  4-Apr-2020 - initialize marker size (grmsiz) to its default value [EC].
   !-----------------------------------------------------------------------

   integer :: ier, ftype, ibuf(4), lchr
   double precision :: rbuf(6)
   logical :: append
   character(len=128) :: ffile, chr

   !------ end of declarations -- execution starts hereafter  ------

   ! GRINIT call has been removed, as this routine is always called by
   ! PGOPEN which call itself GRINIT (via PGINIT).

   ! Allocate an identifier.
   ident = 1
   do while( grstat(ident) /= 0 )
      ident = ident + 1
      if( ident > grimax ) then
         call grwarn("Too many active plots.")
         gropen = -1
         ident = 0
         return
      end if
   end do

   ! Validate the device specification.
   ! (GRPARS set GRGTYP to the right value, via GRDTYP)
   ier = grpars( file, ffile, ftype, append )
   if( ier /= 1 ) then
      chr = "Invalid device specification: "
      chr(31:) = file
      call grwarn(chr)
      gropen = -1
      return
   end if
   if( ftype == 0 ) ftype = type
   if( 1 <= ftype ) then
      grtype(ident) = ftype
   else
      chr = "Device type omitted or invalid: "
      chr(33:) = file
      call grwarn(chr)
      gropen = -1
      return
   end if

   ! Install the file name.
   grfile(ident) = ffile
   grfnln(ident) = max(1,len_trim(grfile(ident)))

   ! Opening device
   call grexec( grgtyp, OPEN_DEV, rbuf, ibuf, grfile(ident), grfnln(ident) )
   gropen = ibuf(2)
   if( gropen /= 1 ) then
      ident = 0
      return
   end if
   grunit(ident) = ibuf(1)
   grpltd(ident) = .false.
   grstat(ident) = 1
   call grslct(ident)

   ! Install the default plot parameters

   ! Inquire color-index range.
   call grexec( grgtyp, GET_COL_IND_RANGE, rbuf, ibuf, chr, lchr )
   grmnci(ident) = ibuf(1)
   grmxci(ident) = ibuf(2)
   ! Inquire resolution.
   call grexec( grgtyp, GET_DEV_RESOL, rbuf, ibuf, chr, lchr )
   grpxpi(ident) = ibuf(1)
   grpypi(ident) = ibuf(2)
   ! Inquire default character size.
   ! EPS and PDF drivers are designed to use 8.0
   grcfac(ident) = 8.0d0

   ! Inquire default plot size.
   ibuf(1) = 0 ! no need to wait a few tens of milliseconds
   rbuf(1) = 1. ! request of the full drawing area
   call grexec( grgtyp, GET_DEF_SIZE, rbuf, ibuf, chr, lchr )
   grxmxa(ident) = ibuf(2)
   grymxa(ident) = ibuf(4)
   grxmin(ident) = ibuf(1)
   grxmax(ident) = ibuf(2)
   grymin(ident) = ibuf(3)
   grymax(ident) = ibuf(4)
   ! Inquire device capabilities.
   grgcap(ident) = "NNNNNNNNNN"
   call grexec( grgtyp, GET_MISC_INFO, rbuf, ibuf, chr, lchr )
   grgcap(ident) = chr(1:lchr)
   ! Current pen position.
   grxpre(ident) = 0.0d0
   grypre(ident) = 0.0d0

   gropen = 1

end function
