! GRMOVA -- move pen (absolute, world coordinates)

subroutine GRMOVA( x, y )

   double precision, intent(in) :: x, y
   !------ API end ------

   ! GRPCKG: move the pen to a specified location.
   !
   ! Arguments:
   !
   ! X, Y (real, input): world coordinates of the new pen position.
   !--
   ! (1-Feb-1983)
   ! 29-Feb-2020 - Use now double precision instead of single precision.
   ! 24-Mar-2020 - Add MIN/MAX kluge to prevent overflow (similar to lines
   !               30-31 in GRLIN0).
   !-----------------------------------------------------------------------

   double precision :: x0, y0

   !------ end of declarations -- execution starts hereafter  ------

   if( grcide >= 1 ) then

      x0 = x * grxscl(grcide) + grxorg(grcide)
      y0 = y * gryscl(grcide) + gryorg(grcide)

      ! force coordinates to lie in [ -1e30, 1e30 ]
      grxpre(grcide) = min( 1.0d30, max(-1.0d30,x0) )
      grypre(grcide) = min( 1.0d30, max(-1.0d30,y0) )

   end if

end subroutine
