! GRLIN3 -- Draw a polyline in one pass (only for X11 device)

subroutine GRLIN3( n, px, py )

   integer,          intent(in) :: n
   double precision, intent(in) :: px(*), py(*)
   !------ API end ------

   ! GRPCKG : Same as GRLIN2 but for an array of coordinates (px,py).
   !
   ! Arguments:
   !
   ! N : the number of vertices of the polyline (at least 2).
   ! PX, PY : device coordinates of the points of the polyline.
   !
   ! In this routine, we are sure that all device coordinates are not
   ! too large for Xlib (see test added in PGLINE2)
   !--
   !  1-Dec-2021 - Creation
   !  2-Dec-2021 - Avoid drawing segments which are outside the axes.
   !  1-Mar-2023 - Remove truncation for large integers in Xlib.
   !-----------------------------------------------------------------------

   integer :: i, j, k, k_max, k1, k2, m, n_sub, npts, ii, n_seg
   logical :: in_range
   double precision :: xmin, ymin, xmax, ymax
   logical, allocatable :: valid_segments(:)
   integer, allocatable :: valid_ranges(:)

   integer :: lchr
   integer, allocatable :: ibuf(:)
   double precision :: rbuf(1)
   character :: chr

   !------ end of declarations -- execution starts hereafter  ------

   ! If this is the first thing plotted then set something plotted flag
   ! and for a GREXEC device call BEGIN_PICTURE.
   if( .not. grpltd(grcide) ) call grbpic

   m = 2*n+1
   allocate( ibuf(m) )
   ! ibuf(1) will be set later on to the effective number of points for
   ! each group of visible segments

   ! Quick return if possible (actually, elimination of further segments,
   ! which are outside the axes).
   if( CLIPPING_IN_AXES ) then

      allocate( valid_segments(n-1) )

      ! Loop over segments of 2 points
      do i = 1, n-1
         ! consider the segment [i,i+1]
         xmin = min( px(i), px(i+1) )
         xmax = max( px(i), px(i+1) )
         ymin = min( py(i), py(i+1) )
         ymax = max( py(i), py(i+1) )
         ! test the segment
         valid_segments(i) = .true.
         if( xmax < grxmin(grcide) ) valid_segments(i) = .false.
         if( xmin > grxmax(grcide) ) valid_segments(i) = .false.
         if( ymax < grymin(grcide) ) valid_segments(i) = .false.
         if( ymin > grymax(grcide) ) valid_segments(i) = .false.
      end do

      ! Now collect indices of contiguous valid segments
      ! (about the size of valid_ranges, worse case is when one segment
      !  over two is valid: in this case we need n elements)
      allocate( valid_ranges(n) )
      k = 0
      in_range = .false.
      do i = 1, n-1
         if( valid_segments(i) ) then
            if( .not. in_range ) then
               k = k + 1
               valid_ranges(k) = i
               in_range = .true.
            end if
         else
            if( in_range ) then
               k = k + 1
               valid_ranges(k) = i - 1
               in_range = .false.
            end if
         end if
      end do
      if( in_range ) then
         k = k + 1
         valid_ranges(k) = n-1
      end if
      k_max = k

      if( mod(k_max,2) /= 0 ) then
         print "(/,A)", "(MUESLI grlin3:) internal error ***"
         print *, "    -> k_max should be even."
         return
      end if

      if( k_max == 0 ) return

      n_sub = k_max / 2

      do j = 1, n_sub
         k1 = valid_ranges(2*j-1)
         k2 = valid_ranges(2*j)
         n_seg = k2 - k1 + 1
         if( n_seg == 1 ) then
            ! k1 = k2
            ibuf(1) = nint(px(k1))
            ibuf(2) = nint(py(k1))
            ibuf(3) = nint(px(k2+1))
            ibuf(4) = nint(py(k2+1))
            call grexec( grgtyp, DRAW_LINE_SEGM, rbuf, ibuf, chr, lchr )
         else
            npts = n_seg + 1
            ibuf(1) = npts
            do i = 1, npts
               ii = i - 1 + k1
               ibuf(2*i)   = nint(px(ii))
               ibuf(2*i+1) = nint(py(ii))
            end do
            call grexec( grgtyp, DRAW_POLYLINE, rbuf, ibuf, chr, lchr )
         end if
      end do

   else ! Not CLIPPING_IN_AXES

      ibuf(1) = n

      do i = 1, n
         ibuf(2*i)   = nint(px(i))
         ibuf(2*i+1) = nint(py(i))
      end do

      call grexec( grgtyp, DRAW_POLYLINE, rbuf, ibuf, chr, lchr )

   end if

end subroutine
