! GRLIN2 -- draw one straight segment.

subroutine GRLIN2( x0, y0, x1, y1 )

   double precision, intent(in) :: x0, y0, x1, y1
   !------ API end ------

   ! GRPCKG : plot a visible line segment in absolute coords from
   ! (X0,Y0) to (X1,Y1).  The endpoints of the line segment will be rounded
   ! to the nearest integer and passed to the appropriate device-specific
   ! routine. It is assumed that the entire line-segment lies within the
   ! view surface, and that the physical device coordinates are
   ! non-negative.
   !--
   ! (1-Jun-1984)
   ! 19-Oct-1984 - Rewritten for speed [TJP].
   ! 29-Jan-1985 - Add HP2648 device [KS/TJP].
   !  5-Aug-1986 - Add GREXEC support [AFT].
   ! 21-Feb-1987 - If needed, calls begin picture [AFT].
   ! 29-Feb-2020 - Use now double precision instead of single precision.
   ! 13-Apr-2021 - Take care of integer overflow in the X11 driver
   !               (In Xlib, XPoint coordinates are 'short int').
   !  1-Mar-2023 - Fix a bug: change truncation for large integers in Xlib.
   !-----------------------------------------------------------------------

   character(len=32) :: dev_typ
   logical :: ldummy
   double precision :: xmin, ymin, xmax, ymax
   integer :: status

   double precision :: rbuf(1)
   integer :: ibuf(4), lchr
   character :: chr

   !------ end of declarations -- execution starts hereafter  ------

   ! If this is the first thing plotted then set something plotted flag
   ! and for a GREXEC device call BEGIN_PICTURE.
   if( .not. grpltd(grcide) ) call grbpic

   ! Quick return if possible
   if( CLIPPING_IN_AXES ) then
      xmin = min( x0, x1 )
      xmax = max( x0, x1 )
      ymin = min( y0, y1 )
      ymax = max( y0, y1 )

      if( xmax < grxmin(grcide) ) return
      if( xmin > grxmax(grcide) ) return
      if( ymax < grymin(grcide) ) return
      if( ymin > grymax(grcide) ) return
   end if

   call grqtyp( dev_typ, ldummy )
   if( trim(dev_typ) == "XWINDOW" ) then
      ! Take care of overflow in integers; in Xlib, device coordinates
      ! are limited to 8 or 16-bit. See the MOD_GRPLOT module.
      call restrict_to_short_3( x0, y0, x1, y1,                         &
                                ibuf(1), ibuf(2), ibuf(3), ibuf(4),     &
                                status )
      if( status == 1 ) return ! X11 failure

      call grexec( grgtyp, DRAW_LINE_SEGM, rbuf, ibuf, chr, lchr )
   else ! NULL, EPS or PDF
      ! Strange conversion to zero may occur if the real X is greater
      ! than huge(1)=2147483647...
      ibuf(1) = restrict_to_long(x0)
      ibuf(2) = restrict_to_long(y0)
      ibuf(3) = restrict_to_long(x1)
      ibuf(4) = restrict_to_long(y1)
      lchr = 0 ! keep this value, it will be tested in EPS and PDF driver.
      call grexec( grgtyp, DRAW_POLYLINE, rbuf, ibuf, chr, lchr )
   end if

end subroutine
