! GRLIN0 -- draw a line

subroutine GRLIN0( x1, y1 )

   double precision :: x1, y1
   !------ API end ------

   ! GRPCKG (internal routine): draw a line from the current position to a
   ! specified position, which becomes the new current position. This
   ! routine takes care of normal, dashed and thick lines.
   !
   ! Arguments:
   !
   ! X1, Y1 (input, real): absolute device coordinates of the end-point of
   !                       the line.
   !--
   ! 13-Jul-1984
   !  7-May-1985 - Add MIN/MAX kluge to prevent integer overflow [TJP].
   ! 30-Aug-2018 - Enlarge min and max possible values;
   !               change clipping policy.
   ! 29-Feb-2020 - Use now double precision instead of single precision.
   ! 14-Mar-2021 - Clipping is suppressed (made in the drivers).
   ! 15-Apr-2021 - Removed call to GRLIN3, because all devices support
   !               thick lines.
   ! 27-Nov-2021 - Removed restriction of coordinates, because of
   !               redondancy.
   !  2-Dec-2021 - Removed call to GRLIN1, since dashing is always done
   !               by the hardware.
   !-----------------------------------------------------------------------

   double precision :: x0, y0

   !------ end of declarations -- execution starts hereafter  ------

   ! End-points of line are (X0,Y0), (X1,Y1).
   x0 = grxpre(grcide)
   y0 = grypre(grcide)

   grxpre(grcide) = x1
   grypre(grcide) = y1

   ! Draw the line in the appropriate style.
   ! (continuous line or hardware dash)
   call grlin2( x0, y0, x1, y1)

end subroutine
