! GRIMG2 -- image of a 2D data array (pixel-primitive devices -- X11)

subroutine GRIMG2( a, idim, jdim, i1, i2, j1, j2,                       &
                   a1, a2, pa, minind, maxind, mode )

   integer :: idim, jdim, i1, i2, j1, j2, minind, maxind, mode
   double precision :: a(idim,jdim)
   double precision :: a1, a2
   double precision :: pa(6)
   !------ API end ------

   ! (This routine is called by GRIMG0.)
   !--
   !  7-Sep-1994 - New routine [TJP].
   !  1-Jul-2013 - Support of transparent pixel (NONE color) by setting
   !               Index Value (IV) to 15 (light gray).
   ! 29-Feb-2020 - Use now double precision instead of single precision.
   !-----------------------------------------------------------------------

   integer :: i, iv, ix, ix1, ix2, iy, iy1, iy2, j, npix, lchr
   double precision :: den, av, sfacl
   double precision, parameter :: sfac = 65000.0
   double precision :: xxaa, xxbb, yyaa, yybb, xyaa, xybb, yxaa, yxbb,  &
                       xyaaiy, yxaaiy
   integer, parameter :: buffer_size = 4096
   integer :: ibuf(buffer_size)
   double precision :: rbuf(1)
   character(len=1) :: chr

   !------ end of declarations -- execution starts hereafter  ------

   ! Location of current window in device coordinates.
   ix1 = nint(grxmin(grcide))+1
   ix2 = nint(grxmax(grcide))-1
   iy1 = nint(grymin(grcide))+1
   iy2 = nint(grymax(grcide))-1

   ! Transformation from array coordinates to device coordinates.
   den = pa(2)*pa(6)-pa(3)*pa(5)
   xxaa = (-pa(6))*pa(1)/den
   xxbb = pa(6)/den
   xyaa = (-pa(3))*pa(4)/den
   xybb = pa(3)/den
   yyaa = (-pa(2))*pa(4)/den
   yybb = pa(2)/den
   yxaa = (-pa(5))*pa(1)/den
   yxbb = pa(5)/den

   ! Start a new page if necessary.
   if( .not. grpltd(grcide) ) call grbpic

   ! Run through every device pixel (IX, IY) in the current window and
   ! determine which array pixel (I,J) it falls in.
   sfacl = log(1.0+sfac)
   do iy = iy1, iy2

      xyaaiy = xxaa-xyaa-xybb*iy
      yxaaiy = yyaa+yybb*iy-yxaa
      npix = 0
      ibuf(3) = iy
      do ix = ix1, ix2
         i = nint(xyaaiy+xxbb*ix)
         if( i < i1 .or. i2 < i ) cycle
         j = nint(yxaaiy-yxbb*ix)
         if( j < j1 .or. j2 < j ) cycle

         ! determine color index IV of this pixel
         av = a(i,j)
         if( av /= av ) then
            ! AV is NaN
            iv = 15 ! Transparent pixels are drawn in light gray
         else
            if( a2 > a1 ) then
               av = min(a2, max(a1,av))
            else
               av = min(a1, max(a2,av))
            end if
            if( mode == 0 ) then
               iv = nint((minind*(a2-av) + maxind*(av-a1))/(a2-a1))
            else if( mode == 1 ) then
               iv = minind + nint((maxind-minind)*                      &
                    log(1.0+sfac*abs((av-a1)/(a2-a1)))/sfacl)
            else if( mode == 2 ) then
               iv = minind + nint((maxind-minind)*                      &
                                   sqrt(abs((av-a1)/(a2-a1))))
            else
               iv = minind
            end if
         end if

         if( npix <= buffer_size-2 ) then
            ! drop pixels if buffer too small (to be fixed!)
            npix = npix + 1
            if( npix == 1 ) ibuf(2) = ix
            ibuf(npix+3) = iv
         end if
      end do

      if( npix > 0 ) then
         ibuf(1) = npix
         call grexec( grgtyp, PUT_LINE_PIX_CI, rbuf, ibuf, chr, lchr )
      end if

   end do

end subroutine
