! GRIMG1 -- image of a 2D data array (image-primitive devices -- EPS or PDF)

subroutine GRIMG1( a, idim, jdim, i1, i2, j1, j2,                       &
                   a1, a2, pa, minind, maxind, mode )

   integer :: idim, jdim, i1, i2, j1, j2, minind, maxind, mode
   double precision :: a(idim,jdim), a1, a2, pa(6)
   !------ API end ------

   ! (This routine is called by GRIMG0.)
   !--
   !  7-Sep-1994 - New routine [TJP].
   !  2-Jul-2013 - Support of transparent pixel (NONE color) by setting
   !               Index Value (IV) to 15 (light gray).
   ! 29-Feb-2020 - Use now double precision instead of single precision.
   !-----------------------------------------------------------------------

   integer, parameter :: ibuf_size = 1024
   integer :: ibuf(ibuf_size), lchr
   double precision :: rbuf(15), fac, av, sfacl
   double precision, parameter :: sfac = 65000.0
   character(len=1) :: chr
   integer :: i, j, ii, nxp, nyp, iv
   character(len=12) :: type
   logical :: interactive

   !------ end of declarations -- execution starts hereafter  ------

   ! Size of image.
   nxp = i2 - i1 + 1
   nyp = j2 - j1 + 1
   ibuf(1) = 0
   ibuf(2) = nxp
   ibuf(3) = nyp

   ! Clipping rectangle.
   rbuf(1) = grxmin(grcide)
   rbuf(2) = grxmax(grcide)
   rbuf(3) = grymin(grcide)
   rbuf(4) = grymax(grcide)

   ! Image transformation matrix.
   fac = pa(2)*pa(6) - pa(3)*pa(5)
   rbuf(5)  =  pa(6)/fac
   rbuf(6)  = (-pa(5))/fac
   rbuf(7) = (-pa(3))/fac
   rbuf(8) =  pa(2)/fac
   rbuf(9) = (pa(3)*pa(4) - pa(1)*pa(6))/fac - (i1-0.5)
   rbuf(10) = (pa(5)*pa(1) - pa(4)*pa(2))/fac - (j1-0.5)
   ! Warning: for PDF, the matrix transformation doesn't have the same
   !          definition. Therefore it is better to send the original
   !          matrix  (not inverted)...
   call grqtyp( type, interactive )
   if( type == 'PDF' ) then
      rbuf(11) = PA(2)
      rbuf(12) = PA(3)
      rbuf(13) = PA(5)
      rbuf(14) = pa(6)
      rbuf(15) = fac
   end if

   ! Send setup info to driver.
   if( .not. grpltd(grcide) ) call grbpic
   lchr = 0
   call grexec( grgtyp, BITMAP_IMAGE, rbuf, ibuf, chr, lchr )

   ! Convert image array to color indices and send to driver.
   sfacl = log(1.0+sfac)
   ii = 0
   do j = j1, j2
       do i = i1, i2

           av = a(i,j)
           if( av /= av ) then
              ! AV is NaN
              iv = 15 ! Transparent pixels are drawn in light gray
           else
              if( a2 > a1 ) then
                 av = min(a2, max(a1,av))
              else
                 av = min(a1, max(a2,av))
              end if
              if( mode == 0 ) then
                 iv = nint((minind*(a2-av) + maxind*(av-a1))/(a2-a1))
              else if( mode == 1 ) then
                 iv = minind + nint((maxind-minind)*                     &
                               log(1.0+sfac*abs((av-a1)/(a2-a1)))/sfacl)
              else if( mode == 2 ) then
                 iv = minind + nint((maxind-minind)*                     &
                               sqrt(abs((av-a1)/(a2-a1))))
              else
                 iv = minind
              end if
           end if

           ii = ii + 1
           ibuf(ii+1) = iv
           if( ii == ibuf_size-1 ) then
               ibuf(1) = ii
               call grexec( grgtyp, BITMAP_IMAGE, rbuf, ibuf, chr, lchr )
               ii = 0
           end if

       end do
   end do
   if( ii > 0 ) then
       ibuf(1) = ii
       call grexec( grgtyp, BITMAP_IMAGE, rbuf, ibuf, chr, lchr )
       ii = 0
   end if

   ! Send termination code to driver.
   ibuf(1) = -1
   call grexec( grgtyp, BITMAP_IMAGE, rbuf, ibuf, chr, lchr )

end subroutine
