! GRIMG0 -- color image of a 2D data array

subroutine GRIMG0( a, idim, jdim, i1, i2, j1, j2,                       &
                   a1, a2, pa, minind, maxind, mode )

   integer :: idim, jdim, i1, i2, j1, j2, minind, maxind, mode
   double precision :: a(idim,jdim), a1, a2, pa(6)
   !------ API end ------

   ! GRIMG0 -- color image of a 2D data array
   ! This is a support routine for PGIMAG.
   !
   ! Arguments:
   !  A      (input)  : the array to be plotted.
   !  IDIM   (input)  : the first dimension of array A.
   !  JDIM   (input)  : the second dimension of array A.
   !  I1, I2 (input)  : the inclusive range of the first index
   !                    (I) to be plotted.
   !  J1, J2 (input)  : the inclusive range of the second
   !                    index (J) to be plotted.
   !  A1     (input)  : the array value which is to appear in color
   !                    index MININD.
   !  A2     (input)  : the array value which is to appear in color
   !                    index MAXIND.
   !  PA     (input)  : transformation matrix between array grid and
   !                    device coordinates.
   !  MININD (input)  : minimum color index to use.
   !  MAXIND (input)  : maximum color index to use.
   !  MODE   (input)  : =0 for linear, =1 for logarithmic, =2 for
   !                    square-root mapping of array values to color
   !                    indices.
   !--
   !  7-Sep-1994 - New routine [TJP].
   ! 29-Feb-2020 - Use now double precision instead of single precision [EC].
   !-----------------------------------------------------------------------

   character :: c
   !------ end of declarations -- execution starts hereafter  ------

   ! Switch on type of device support.

   c = grgcap(grcide)(7:7)
   if( c == 'Q' ) then
      ! Image-primitive devices
      call grimg1( a, idim, jdim, i1, i2, j1, j2, a1, a2, pa, minind, maxind, mode )
   else if( c == 'P' ) then
      ! Pixel-primitive devices
      call grimg2( a, idim, jdim, i1, i2, j1, j2, a1, a2, pa, minind, maxind, mode )
   else if( c == 'N' ) then
      ! Other devices
      call grwarn( "images cannot be displayed on the selected device" )
   else
      ! Unknown device code
      call grwarn('unexpected error in routine GRIMG0')
   end if

end subroutine
