! GRFA -- fill area (polygon)

subroutine GRFA( n, px, py )

   integer,          intent(in) :: n
   double precision, intent(in) :: px(*), py(*)
   !------ API end ------

   ! GRPCKG: FILL AREA: fills a polygon with solid color.  The polygon is
   ! defined by the (x,y) world coordinates of its N vertices.
   !
   ! Arguments:
   !
   ! N : the number of vertices of the polygon (at least 3).
   ! PX, PY : world coordinates of the N vertices of the polygon.
   !--
   ! 16-Jul-1984 - [TJP].
   !  5-Aug-1986 - Add GREXEC support [AFT].
   ! 21-Feb-1987 - If needed, calls begin picture [AFT].
   !  7-Sep-1994 - Avoid driver call for capabilities [TJP].
   !  1-May-1995 - Fixed bug for re-entrant polygons, and optimized code
   !               [A.F.Carman].
   ! 18-Oct-1995 - Fixed bug: emulated fill failed for reversed y-axis
   !               [S.C.Allendorf/TJP].
   !  4-Dec-1995 - Remove use of real variable as do-loop variable [TJP].
   ! 20-Mar-1996 - Use another do loop 40 to avoid gaps between adjacent
   !               polygons [RS]
   ! 29-Feb-2020 - Use now double precision instead of single precision.
   ! 14-Mar-2021 - Simplified the routine, assuming that all devices support
   !               the 'Fill Area feature'. Also use dynamic allocation of
   !               rbuf(:) to avoid multiple calls to the drivers.
   ! 14-Apr-2021 - Take care of integer overflow in the X11 driver
   !               (In Xlib, XPoint coordinates are 'short int').
   !  1-Mar-2023 - Fix a bug: change truncation for large integers in Xlib.
   !-----------------------------------------------------------------------

   integer :: i, m, status
   double precision :: x0, y0, x1, y1

   character(len=32) :: dev_typ
   logical :: ldummy

   integer :: lchr
   integer, allocatable :: ibuf(:)
   double precision :: rbuf(1)
   character :: chr

   !------ end of declarations -- execution starts hereafter  ------

   if( grcide < 1 ) return
   if( n < 3 ) then
       call grwarn('GRFA - polygon has less than 3 vertices.')
       return
   end if

   if( .not. grpltd(grcide) ) call grbpic

   m = max( 2*n+1, 5 )
   allocate( ibuf(m) )

   ibuf(1) = n
   call grqtyp( dev_typ, ldummy )
   if( trim(dev_typ) == "XWINDOW" ) then
      ! Take care of overflow in integers; in Xlib, device coordinates
      ! are limited to 8 or 16-bit. See the MOD_GRPLOT module.
      do i = 1, n-1, 2
         x0 = px(i)*grxscl(grcide) + grxorg(grcide)
         y0 = py(i)*gryscl(grcide) + gryorg(grcide)
         x1 = px(i+1)*grxscl(grcide) + grxorg(grcide)
         y1 = py(i+1)*gryscl(grcide) + gryorg(grcide)
         call restrict_to_short_3( x0, y0, x1, y1,                      &
                                   ibuf(2*i), ibuf(2*i+1),              &
                                   ibuf(2*(i+1)), ibuf(2*(i+1)+1),      &
                                   status )
         if( status == 1 ) return ! X11 failure
      end do
      if( mod(n,2) /= 0 ) then
         x0 = px(n)*grxscl(grcide) + grxorg(grcide)
         y0 = py(n)*gryscl(grcide) + gryorg(grcide)
         x1 = px(1)*grxscl(grcide) + grxorg(grcide)
         y1 = py(1)*gryscl(grcide) + gryorg(grcide)
         call restrict_to_short_3( x0, y0, x1, y1,                      &
                                   ibuf(2*n), ibuf(2*n+1),              &
                                   ibuf(2), ibuf(3),                    &
                                   status )
         if( status == 1 ) return ! X11 failure
      end if

   else ! NULL, EPS or PDF

      do i = 1, n
         ibuf(2*i)   = nint( px(i)*grxscl(grcide) + grxorg(grcide) )
         ibuf(2*i+1) = nint( py(i)*gryscl(grcide) + gryorg(grcide) )
      end do

   end if

   call grexec( grgtyp, POLYGON_FILL, rbuf, ibuf, chr, lchr )

end subroutine
