! GREXEC -- MFPLOT device handler dispatch routine

subroutine GREXEC( idev, ifunc, rbuf, ibuf, chr, lchr )

   integer, intent(in) :: idev, ifunc
   double precision    :: rbuf(*)
   integer             :: ibuf(*)
   character(len=*)    :: chr
   integer             :: lchr
   !------ API end ------

   ! Avoid to add explicit intent to the above argument. Most of args
   ! are both "in" and "out", but not for all opcode IFUNC. This allows
   ! calling routine adapt their argument passing and avoid multiple copies.

   !---
   ! 29-Feb-2020 - Use now double precision instead of single precision.
   ! 28-Jun-2020 - Remove /XSERVE (idev=7), never used.
   !  6-Jul-2021 - Change the device numbering to increase time access.
   !               Introduce new parameters for the device types, defined
   !               in mod_grplot.F90
   !-----------------------------------------------------------------------

   character(len=16) :: msg

   !------ end of declarations -- execution starts hereafter  ------

   select case( idev )
      case( X11_DRIVER_NUM )
#ifndef _NO_X11
         call x11_driver( ifunc, rbuf, ibuf, chr, lchr )
#endif
      case( EPS_DRIVER_NUM )
         call eps_driver( ifunc, rbuf, ibuf, chr, lchr )
      case( PDF_DRIVER_NUM )
         call pdf_driver( ifunc, rbuf, ibuf, chr, lchr )
      case( NULL_DRIVER_NUM )
         call null_driver( ifunc, rbuf, ibuf, chr, lchr )
      case( 0 )
         ! special call to return the number of different devices
         ibuf(1) = MF_DEV_TYPE_NUMBER
      case default
         write( msg, "(I0)" ) idev
         call grwarn( "Unknown device code in GREXEC: " // msg )
         pause "only for debugging purpose"
         stop 'Internal error'
   end select

end subroutine
