! GRESC -- escape routine

subroutine GRESC( text )

   character(len=*), intent(in) :: text
   !------ API end ------

   ! GRPCKG: "Escape" routine. The specified text is sent directly to the
   ! selected graphics device, with no interpretation by GRPCKG. This
   ! routine must be used with care; e.g., the programmer needs to know
   ! the device type of the currently selected device, and the instructions
   ! that the device can accept.
   !
   ! Arguments: none.
   !  TEXT (input):  text to be sent to the device.
   !
   ! 15-May-1985 - New routine [TJP].
   ! 26-May-1987 - Add GREXEC support [TJP].
   ! 19-Dec-1988 - Start new page if necessary [TJP].
   !  4-Feb-1997 - RBUF should be an array, not a scalar [TJP].
   ! 29-Feb-2020 - Use now double precision instead of single precision [EC].
   !-----------------------------------------------------------------------

   double precision :: rbuf(1)
   integer :: ibuf(1)

   !------ end of declarations -- execution starts hereafter  ------

   ! If no device is currently selected, do nothing.
   if( grcide > 0 ) then
      if( .not. grpltd(grcide) ) call grbpic
      call grexec( grgtyp, ESCAPE, rbuf, ibuf, text, len(text) )
   end if

end subroutine
