! GRDTYP -- decode graphics device type string

integer function GRDTYP( text )

   character(len=*), intent(in) :: text
   !------ API end ------

   ! GRPCKG (internal routine): determine graphics device type code from
   ! type name. It compares the argument with the table of known device
   ! types in common.
   ! As a side effect, the global variable GRGTYP is set.
   !
   ! Argument:
   !
   ! TEXT (input, character): device type name, eg 'PRINTRONIX'; the name
   !       may be abbreviated to uniqueness.
   !
   ! Returns:
   !
   ! GRDTYP (integer): the device type code, in the range 1 to
   !       GRTMAX, zero if the type name is not recognised, or -1
   !       if the type name is ambiguous.
   !--
   ! 27-Dec-1984 - Rewrite so that is doesn't have to be modified for
   !               new devices [TJP].
   !  5-Aug-1986 - Add GREXEC support [AFT].
   ! 10-Nov-1995 - Ignore drivers that report no device type [TJP].
   ! 30-Aug-1996 - Check for an exact match; indicate if type is
   !               ambiguous [TJP].
   ! 29-Feb-2020 - Use now double precision instead of single precision [EC].
   !-----------------------------------------------------------------------

   integer :: code, i, l, match
   double precision :: rbuf(1)
   integer :: ndev, ibuf(1), lchr
   character(len=32) :: chr

   !------ end of declarations -- execution starts hereafter  ------

   grdtyp = 0
   l = len_trim(text)
   if( l < 1 ) return
   match = 0
   code = 0
   ! Get the device number via a special call
   call grexec( 0, 0, rbuf, ibuf, chr, lchr )
   ndev = ibuf(1)
   do i = 1, ndev
      call grexec( i, GET_DEV_NAME, rbuf, ibuf, chr, lchr )
      if( lchr > 0 ) then
         if( text(1:l) == chr(1:l) ) then
            if( chr(l+1:l+1) == ' ' ) then
               ! exact match
               grdtyp = i
               grgtyp = grdtyp
               return
            else
               match = match+1
               code = i
            end if
         end if
      end if
   end do
   if( match == 0 ) then
      ! no match
      grdtyp = 0
   else if( match == 1 ) then
      grdtyp = code
      grgtyp = grdtyp
   else
      grdtyp = -1
   end if

end function
