! GRCLOS -- Close graphics device

subroutine GRCLOS

   ! GRPCKG: Close the open plot on the current device. Any pending output
   ! is sent to the device, the device or the disk file is closed, and no
   ! further plotting is allowed on the device without a new call to GROPEN.
   !
   ! Arguments: none.
   !--
   !  1-Jun-1984 - [TJP].
   ! 17-Jul-1984 - Ignore call if plot is not open [TJP].
   !  1-Oct-1984 - Reset color to default (1) and position text cursor
   !               at bottom of VT screen [TJP].
   ! 19-Oct-1984 - Add VV device [TJP].
   ! 22-Dec-1984 - Use GRBUFL and GRIOTA parameters [TJP].
   !  5-Aug-1986 - Add GREXEC support [AFT].
   ! 21-Feb-1987 - Modify END_PICTURE sequence [AFT].
   ! 11-Jun-1987 - Remove built-ins [TJP].
   ! 31-Aug-1987 - Do not eject blank page [TJP].
   ! 29-Feb-2020 - Use now double precision instead of single precision [EC].
   !-----------------------------------------------------------------------

   double precision :: rbuf(1)
   integer :: ibuf(4), lchr
   character(len=1) :: chr

   !------ end of declarations -- execution starts hereafter  ------

   ! Check that the plot is open.
   if( grcide < 1 ) return

   ! Flush buffer.
   call grterm

   ! End picture.
   call grepic

   ! This plot identifier is no longer in use.
   grstat(grcide) = 0

   ! Set state to "workstation closed".
   grcide = 0

   ! Close workstation.
   call grexec( grgtyp, CLOSE_DEV, rbuf, ibuf, chr, lchr )

end subroutine
