! GRAREA -- define a clipping window

subroutine GRAREA( x0, y0, xsize, ysize )

   double precision, intent(in) :: x0, y0, xsize, ysize
   !------ API end ------

   ! GRPCKG: Define a rectangular window in the current plotting area. All
   ! graphics (except characters written with GRCHAR) will be blanked
   ! outside this window.  The default window is the full plotting area.
   !
   ! Arguments:
   !
   ! X0, Y0 (input): lower left corner of the window, in abs. device coords.
   !
   ! XSIZE, YSIZE (input): width and height of the window, in abs. dev. coords;
   !                       if either is negative or null, the window will be
   !                       reset to the full plotting area.
   !--
   !  1-Feb-1983 - [TJP].
   ! 25-Nov-1994 - Use floating-point [TJP].
   ! 16-Jul-2007 - For PS family, increase max size in order to get
   !               correct labeling for colorbars.
   ! 29-Feb-2020 - Use now double precision instead of single precision.
   ! 11-Apr-2020 - Suppress the argument IDENT.
   !  5-Apr-2021 - Sne dthe viewport BBox to the X11 driver.
   !-----------------------------------------------------------------------

   character(len=32) :: dev_typ
   logical :: ldummy

   double precision :: rbuf(1)
   integer :: ibuf(4), lchr
   character :: chr

   !------ end of declarations -- execution starts hereafter  ------

   if( xsize <= 0.0 .or. ysize <= 0.0 ) then
      ! default plotting area = full plotting area
      grxmin(grcide) = 0
      grxmax(grcide) = grxmxa(grcide)
      grymin(grcide) = 0
      grymax(grcide) = grymxa(grcide)

      ! particular case of EPS (which are not strictly PS files): there is
      ! no physical size, therefore we must increase the size to avoid a
      ! troncation of a colorbar drawing and its numerical labels.
      call grqtyp( dev_typ, ldummy )
      if( trim(dev_typ) == "EPS" .or. trim(dev_typ) == "PDF" ) then
         grxmax(grcide) = 2*grxmxa(grcide)
         grymax(grcide) = 2*grymxa(grcide)
      end if
   else
      grxmin(grcide) = max( x0, 0.0d0 )
      grymin(grcide) = max( y0, 0.0d0 )
      grxmax(grcide) = min( xsize+x0, dble(grxmxa(grcide)) )
      grymax(grcide) = min( ysize+y0, dble(grymxa(grcide)) )
   end if

   call grqtyp( dev_typ, ldummy )
   if( trim(dev_typ) == "XWINDOW" ) then
      ! send viewport BBox to X11 driver
      ibuf(1) = nint( grxmin(grcide) )
      ibuf(2) = nint( grxmax(grcide) )
      ibuf(3) = nint( grymin(grcide) )
      ibuf(4) = nint( grymax(grcide) )
      call grexec( grgtyp, SET_VIEWPORT, rbuf, ibuf, chr, lchr )
   end if

end subroutine
